/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.navigator.ProjectInfoForPackageExplorer;
import org.python.pydev.navigator.TopLevelProjectsOrWorkingSetChoice;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.PythonFile;
import org.python.pydev.navigator.elements.PythonFolder;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.navigator.elements.PythonProjectSourceFolder;
import org.python.pydev.navigator.elements.PythonResource;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.navigator.filters.PythonNodeFilter;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.OutlineCreatorVisitor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonNatureListener;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.PythonNatureListenersManager;
import org.python.pydev.plugin.preferences.PyTitlePreferencesPage;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.outline.IParsedItem;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PythonBaseModelProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener,
IPythonNatureListener,
IPropertyChangeListener {
    private static final Object[] EMPTY = new Object[0];
    public static final String PYDEV_PACKAGE_EXPORER_PROBLEM_MARKER = "org.python.pydev.PydevProjectErrorMarkers";
    private Map<IProject, ProjectInfoForPackageExplorer> projectToSourceFolders = new HashMap<IProject, ProjectInfoForPackageExplorer>();
    protected CommonViewer viewer;
    protected final TopLevelProjectsOrWorkingSetChoice topLevelChoice;
    private ICommonContentExtensionSite aConfig;
    private IWorkspace[] input;
    public static final boolean DEBUG = false;
    protected static ICallback<List<IWorkingSet>, IWorkspaceRoot> getWorkingSetsCallback = new ICallback<List<IWorkingSet>, IWorkspaceRoot>(){

        public List<IWorkingSet> call(IWorkspaceRoot arg) {
            return Arrays.asList(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets());
        }
    };
    private static Map<IProject, Updater> projectToUpdater = new HashMap<IProject, Updater>();
    private static Object projectToUpdaterLock = new Object();
    private final Object lock = new Object();
    private final Collection<Runnable> delayedRunnableUpdates = new ArrayList<Runnable>();
    private final IResource[] EMPTY_RESOURCE_ARRAY = new IResource[0];

    public PythonBaseModelProvider() {
        PythonNatureListenersManager.addPythonNatureListener(this);
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin != null) {
            IPreferenceStore preferenceStore = plugin.getPreferenceStore();
            preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.topLevelChoice = new TopLevelProjectsOrWorkingSetChoice();
    }

    public void init(ICommonContentExtensionSite aConfig) {
        this.aConfig = aConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Updater getUpdater(IProject project) {
        Object object = projectToUpdaterLock;
        synchronized (object) {
            Updater updater = projectToUpdater.get(project);
            if (updater == null) {
                updater = new Updater();
                projectToUpdater.put(project, updater);
            }
            return updater;
        }
    }

    private void createAndStartUpdater(IProject project, List<String> projectPythonpath) {
        Updater updater = this.getUpdater(project);
        updater.setNeededParameters(project, projectPythonpath);
        updater.schedule(200L);
    }

    @Override
    public void notifyPythonPathRebuilt(IProject project, IPythonNature nature) {
        List<String> projectPythonpath;
        if (project == null) {
            return;
        }
        if (nature == null) {
            projectPythonpath = new ArrayList<String>();
        } else {
            try {
                projectPythonpath = nature.getPythonPathNature().getCompleteProjectPythonPath(nature.getProjectInterpreter(), nature.getRelatedInterpreterManager());
            }
            catch (PythonNatureWithoutProjectException pythonNatureWithoutProjectException) {
                projectPythonpath = new ArrayList();
            }
            catch (MisconfigurationException misconfigurationException) {
                projectPythonpath = new ArrayList();
            }
        }
        this.createAndStartUpdater(project, projectPythonpath);
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWorkspace[] localInput;
        String property = event.getProperty();
        if (PyTitlePreferencesPage.isTitlePreferencesIconRelatedProperty(property) && (localInput = this.input) != null) {
            IWorkspace[] iWorkspaceArray = localInput;
            int n = localInput.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspace iWorkspace = iWorkspaceArray[n2];
                IWorkspaceRoot root = iWorkspace.getRoot();
                if (root != null) {
                    Runnable runnable = this.getRefreshRunnable((IResource)root);
                    ArrayList<Runnable> runnables = new ArrayList<Runnable>();
                    runnables.add(runnable);
                    this.processRunnables(runnables);
                }
                ++n2;
            }
        }
    }

    IResource internalDoNotifyPythonPathRebuilt(IProject project, List<String> projectPythonpath) {
        IProject refreshObject = project;
        HashSet<Path> projectPythonpathSet = new HashSet<Path>();
        for (String string : projectPythonpath) {
            Path newPath = new Path(string);
            if (project.getLocation().equals((Object)newPath)) {
                refreshObject = project.getParent();
            }
            projectPythonpathSet.add(newPath);
        }
        ProjectInfoForPackageExplorer projectInfo = this.getProjectInfo(project);
        if (projectInfo != null) {
            projectInfo.recreateInfo(project);
            Set<PythonSourceFolder> existingSourceFolders = projectInfo.sourceFolders;
            if (existingSourceFolders != null) {
                for (PythonSourceFolder pythonSourceFolder : new HashSet<PythonSourceFolder>(existingSourceFolders)) {
                    IPath fullPath = pythonSourceFolder.container.getLocation();
                    if (projectPythonpathSet.contains(fullPath)) continue;
                    if (pythonSourceFolder instanceof PythonProjectSourceFolder) {
                        refreshObject = project.getParent();
                    }
                    existingSourceFolders.remove(pythonSourceFolder);
                }
            }
        }
        Runnable refreshRunnable = this.getRefreshRunnable((IResource)refreshObject);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        runnables.add(refreshRunnable);
        this.processRunnables(runnables);
        return refreshObject;
    }

    protected Object getResourceInPythonModel(IResource object) {
        return this.getResourceInPythonModel(object, false, false);
    }

    protected Object getResourceInPythonModel(IResource object, boolean returnNullIfNotFound) {
        return this.getResourceInPythonModel(object, false, returnNullIfNotFound);
    }

    protected Object getResourceInPythonModel(IResource object, boolean removeFoundResource, boolean returnNullIfNotFound) {
        Set<PythonSourceFolder> sourceFolders = this.getProjectSourceFolders(object.getProject());
        Object f = null;
        PythonSourceFolder sourceFolder = null;
        Iterator<PythonSourceFolder> it = sourceFolders.iterator();
        while (f == null && it.hasNext()) {
            sourceFolder = it.next();
            f = sourceFolder.getActualObject().equals((Object)object) ? sourceFolder : sourceFolder.getChild(object);
        }
        if (f == null) {
            if (returnNullIfNotFound) {
                return null;
            }
            return object;
        }
        if (removeFoundResource) {
            if (f == sourceFolder) {
                sourceFolders.remove(f);
            } else {
                sourceFolder.removeChild(object);
            }
        }
        return f;
    }

    protected synchronized ProjectInfoForPackageExplorer getProjectInfo(IProject project) {
        if (project == null) {
            return null;
        }
        Map<IProject, ProjectInfoForPackageExplorer> p = this.projectToSourceFolders;
        if (p != null) {
            ProjectInfoForPackageExplorer projectInfo = p.get(project);
            if (projectInfo == null) {
                if (!project.isOpen()) {
                    return null;
                }
                projectInfo = p.get(project);
                if (projectInfo == null) {
                    projectInfo = new ProjectInfoForPackageExplorer(project);
                    p.put(project, projectInfo);
                }
            } else if (!project.isOpen()) {
                p.remove(project);
                projectInfo = null;
            }
            return projectInfo;
        }
        return null;
    }

    protected Set<PythonSourceFolder> getProjectSourceFolders(IProject project) {
        ProjectInfoForPackageExplorer projectInfo = this.getProjectInfo(project);
        if (projectInfo != null) {
            return projectInfo.sourceFolders;
        }
        return new HashSet<PythonSourceFolder>();
    }

    public Object getParent(Object element) {
        Object parent = null;
        Object p = this.topLevelChoice.getWorkingSetParentIfAvailable(element, getWorkingSetsCallback);
        if (p != null) {
            parent = p;
        } else if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            parent = resource.getParentElement();
        } else if (element instanceof IWorkingSet) {
            parent = ResourcesPlugin.getWorkspace().getRoot();
        } else if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            return treeNode.getParent();
        }
        if (parent == null) {
            parent = super.getParent(element);
        }
        return parent;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        if (element instanceof PythonFile) {
            ViewerFilter[] visibleFilters;
            INavigatorContentService contentService = this.viewer.getNavigatorContentService();
            INavigatorFilterService filterService = contentService.getFilterService();
            ViewerFilter[] viewerFilterArray = visibleFilters = filterService.getVisibleFilters(true);
            int n = visibleFilters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray[n2];
                if (viewerFilter instanceof PythonNodeFilter) {
                    return false;
                }
                ++n2;
            }
            PythonFile f = (PythonFile)element;
            if (PythonPathHelper.isValidSourceFile((IFile)f.getActualObject())) {
                try {
                    InputStream contents = f.getContents();
                    try {
                        return contents.read() != -1;
                        {
                        }
                    }
                    finally {
                        contents.close();
                    }
                }
                catch (Exception e) {
                    Log.log((String)"Handled error getting contents.", (Throwable)e);
                    return false;
                }
            }
            return false;
        }
        if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            return treeNode.hasChildren();
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] childrenToReturn = null;
        if (parentElement instanceof IWrappedResource) {
            childrenToReturn = this.getChildrenForIWrappedResource((IWrappedResource)parentElement);
        } else if (parentElement instanceof IResource) {
            childrenToReturn = this.getChildrenForIResourceOrWorkingSet(parentElement);
        } else if (parentElement instanceof IWorkspaceRoot) {
            switch (this.topLevelChoice.getRootMode()) {
                case 0: {
                    return PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
                }
            }
        } else if (parentElement instanceof IWorkingSet) {
            if (parentElement instanceof IWorkingSet) {
                IWorkingSet workingSet = (IWorkingSet)parentElement;
                childrenToReturn = workingSet.getElements();
            }
        } else if (parentElement instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)parentElement;
            return treeNode.getChildren().toArray();
        }
        if (childrenToReturn == null) {
            childrenToReturn = EMPTY;
        }
        return childrenToReturn;
    }

    private Object[] getChildrenForIResourceOrWorkingSet(Object parentElement) {
        PythonNature nature = null;
        IProject project = null;
        if (parentElement instanceof IResource) {
            project = ((IResource)parentElement).getProject();
        }
        if (project != null && project.isOpen()) {
            nature = PythonNature.getPythonNature(project);
        }
        Object[] childrenToReturn = super.getChildren(parentElement);
        ArrayList<Object> ret = new ArrayList<Object>(childrenToReturn.length);
        int i = 0;
        while (i < childrenToReturn.length) {
            block15: {
                PythonNature localNature = nature;
                IProject localProject = project;
                Object child = childrenToReturn[i];
                if (child != null) {
                    ret.add(child);
                    if (child instanceof IResource && (child = this.getResourceInPythonModel((IResource)child)) != null) {
                        ret.set(ret.size() - 1, child);
                        if (child instanceof IContainer && !(child instanceof PythonSourceFolder)) {
                            IContainer container = (IContainer)child;
                            try {
                                IPath fullPath;
                                Set sourcePathSet;
                                if (localNature == null) {
                                    if (!(container instanceof IProject) || !(localProject = (IProject)container).isOpen()) break block15;
                                    localNature = PythonNature.getPythonNature(localProject);
                                }
                                if (localNature != null && (sourcePathSet = localNature.getPythonPathNature().getProjectSourcePathSet(true)).contains((fullPath = container.getFullPath()).toString())) {
                                    PythonSourceFolder createdSourceFolder;
                                    if (container instanceof IFolder) {
                                        createdSourceFolder = new PythonSourceFolder(parentElement, (IFolder)container);
                                    } else if (container instanceof IProject) {
                                        createdSourceFolder = new PythonProjectSourceFolder(parentElement, (IProject)container);
                                    } else {
                                        throw new RuntimeException("Should not get here.");
                                    }
                                    ret.set(ret.size() - 1, createdSourceFolder);
                                    Set<PythonSourceFolder> sourceFolders = this.getProjectSourceFolders(localProject);
                                    sourceFolders.add(createdSourceFolder);
                                }
                            }
                            catch (CoreException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return ret.toArray();
    }

    private Object[] getChildrenForIWrappedResource(IWrappedResource wrappedResourceParent) {
        IResource resource;
        PythonNature nature = null;
        Object[] childrenToReturn = null;
        Object obj = wrappedResourceParent.getActualObject();
        IProject project = null;
        if (obj instanceof IResource && (project = (resource = (IResource)obj).getProject()) != null && project.isOpen()) {
            nature = PythonNature.getPythonNature(project);
        }
        if (wrappedResourceParent instanceof PythonNode) {
            PythonNode node = (PythonNode)wrappedResourceParent;
            childrenToReturn = this.getChildrenFromParsedItem(wrappedResourceParent, node.entry, node.pythonFile);
        } else if (wrappedResourceParent instanceof PythonFile) {
            IProjectModulesManager projectModulesManager;
            String moduleName;
            IModulesManager modulesManager;
            ICodeCompletionASTManager astManager;
            PythonFile file = (PythonFile)wrappedResourceParent;
            if (PythonPathHelper.isValidSourceFile((IFile)file.getActualObject()) && nature != null && (astManager = nature.getAstManager()) != null && (modulesManager = astManager.getModulesManager()) instanceof IProjectModulesManager && (moduleName = (projectModulesManager = (IProjectModulesManager)modulesManager).resolveModuleInDirectManager((IFile)file.getActualObject())) != null) {
                File f;
                String resourceOSString;
                IModule module = projectModulesManager.getModuleInDirectManager(moduleName, (IPythonNature)nature, true);
                if (module == null && (resourceOSString = PydevPlugin.getIResourceOSString(file.getActualObject())) != null && (f = new File(resourceOSString)).exists()) {
                    projectModulesManager.addModule(new ModulesKey(moduleName, f));
                    module = projectModulesManager.getModuleInDirectManager(moduleName, (IPythonNature)nature, true);
                }
                if (module instanceof SourceModule) {
                    SourceModule sourceModule = (SourceModule)module;
                    OutlineCreatorVisitor visitor = OutlineCreatorVisitor.create((SimpleNode)sourceModule.getAst());
                    ParsedItem root = new ParsedItem(visitor.getAll().toArray(new ASTEntryWithChildren[0]), null);
                    childrenToReturn = this.getChildrenFromParsedItem(wrappedResourceParent, root, file);
                }
            }
        } else {
            Object[] children = super.getChildren(wrappedResourceParent.getActualObject());
            childrenToReturn = this.wrapChildren(wrappedResourceParent, wrappedResourceParent.getSourceFolder(), children);
        }
        return childrenToReturn;
    }

    protected Object[] wrapChildren(IWrappedResource parent, PythonSourceFolder pythonSourceFolder, Object[] children) {
        ArrayList<Object> ret = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (object instanceof IResource) {
                Object existing = this.getResourceInPythonModel((IResource)object, true);
                if (existing == null) {
                    if (object instanceof IFolder) {
                        object = new PythonFolder(parent, (IFolder)object, pythonSourceFolder);
                    } else if (object instanceof IFile) {
                        object = new PythonFile(parent, (IFile)object, pythonSourceFolder);
                    } else if (object instanceof IResource) {
                        object = new PythonResource(parent, (IResource)object, pythonSourceFolder);
                    }
                } else {
                    object = existing;
                }
            }
            if (object != null) {
                ret.add(object);
            }
            ++i;
        }
        return ret.toArray();
    }

    private Object[] getChildrenFromParsedItem(Object parentElement, ParsedItem root, PythonFile pythonFile) {
        IParsedItem[] children = root.getChildren();
        Object[] p = new PythonNode[children.length];
        int i = 0;
        IParsedItem[] iParsedItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IParsedItem e = iParsedItemArray[n2];
            p[i] = new PythonNode(pythonFile, parentElement, (ParsedItem)e);
            ++i;
            ++n2;
        }
        return p;
    }

    public void dispose() {
        try {
            this.projectToSourceFolders = null;
            if (this.viewer != null) {
                IWorkspace[] workspace = null;
                Object obj = this.viewer.getInput();
                if (obj instanceof IWorkspace) {
                    workspace = new IWorkspace[]{(IWorkspace)obj};
                } else if (obj instanceof IContainer) {
                    workspace = new IWorkspace[]{((IContainer)obj).getWorkspace()};
                } else if (obj instanceof IWorkingSet) {
                    IWorkingSet newWorkingSet = (IWorkingSet)obj;
                    workspace = this.getWorkspaces(newWorkingSet);
                }
                if (workspace != null) {
                    IWorkspace[] iWorkspaceArray = workspace;
                    int n = workspace.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkspace w = iWorkspaceArray[n2];
                        w.removeResourceChangeListener((IResourceChangeListener)this);
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            PythonNatureListenersManager.removePythonNatureListener(this);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            this.topLevelChoice.dispose();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            super.dispose();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IWorkspace workspace;
        IWorkspace[] iWorkspaceArray;
        IResource iResource;
        Object actualObject;
        IWrappedResource iWrappedResource;
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = (CommonViewer)viewer;
        this.topLevelChoice.init(this.aConfig, this.viewer);
        IWorkspace[] oldWorkspace = null;
        IWorkspace[] newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = new IWorkspace[]{(IWorkspace)oldInput};
        } else if (oldInput instanceof IResource) {
            oldWorkspace = new IWorkspace[]{((IResource)oldInput).getWorkspace()};
        } else if (oldInput instanceof IWrappedResource) {
            iWrappedResource = (IWrappedResource)oldInput;
            actualObject = iWrappedResource.getActualObject();
            if (actualObject instanceof IResource) {
                iResource = (IResource)actualObject;
                oldWorkspace = new IWorkspace[]{iResource.getWorkspace()};
            }
        } else if (oldInput instanceof IWorkingSet) {
            IWorkingSet oldWorkingSet = (IWorkingSet)oldInput;
            oldWorkspace = this.getWorkspaces(oldWorkingSet);
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = new IWorkspace[]{(IWorkspace)newInput};
        } else if (newInput instanceof IResource) {
            newWorkspace = new IWorkspace[]{((IResource)newInput).getWorkspace()};
        } else if (newInput instanceof IWrappedResource) {
            iWrappedResource = (IWrappedResource)newInput;
            actualObject = iWrappedResource.getActualObject();
            if (actualObject instanceof IResource) {
                iResource = (IResource)actualObject;
                newWorkspace = new IWorkspace[]{iResource.getWorkspace()};
            }
        } else if (newInput instanceof IWorkingSet) {
            IWorkingSet newWorkingSet = (IWorkingSet)newInput;
            newWorkspace = this.getWorkspaces(newWorkingSet);
        }
        if (oldWorkspace != null) {
            iWorkspaceArray = oldWorkspace;
            int n = oldWorkspace.length;
            int n2 = 0;
            while (n2 < n) {
                workspace = iWorkspaceArray[n2];
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
                ++n2;
            }
        }
        if (newWorkspace != null) {
            iWorkspaceArray = newWorkspace;
            int n = newWorkspace.length;
            int n3 = 0;
            while (n3 < n) {
                workspace = iWorkspaceArray[n3];
                workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
                ++n3;
            }
        }
        this.input = newWorkspace;
    }

    private IWorkspace[] getWorkspaces(IWorkingSet newWorkingSet) {
        IAdaptable[] elements = newWorkingSet.getElements();
        HashSet<IWorkspace> set = new HashSet<IWorkspace>();
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            IResource adapter = (IResource)adaptable.getAdapter(IResource.class);
            if (adapter != null) {
                IWorkspace workspace = adapter.getWorkspace();
                set.add(workspace);
            } else {
                Log.log((String)"Was not expecting that IWorkingSet adaptable didn't return anything...");
            }
            ++n2;
        }
        return set.toArray(new IWorkspace[0]);
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processDelta(delta, runnables);
        this.processRunnables(runnables);
    }

    private void processRunnables(final Collection<Runnable> runnables) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PythonBaseModelProvider.this.runUpdates(runnables);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdates(Collection<Runnable> runnables) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            Object object = this.lock;
            synchronized (object) {
                this.delayedRunnableUpdates.clear();
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.delayedRunnableUpdates.addAll(runnables);
        }
        if (this.viewer.isBusy()) {
            return;
        }
        ArrayList<Runnable> runnablesToRun = new ArrayList<Runnable>();
        Object object2 = this.lock;
        synchronized (object2) {
            runnablesToRun.addAll(this.delayedRunnableUpdates);
            this.delayedRunnableUpdates.clear();
        }
        for (Runnable runnable : runnablesToRun) {
            runnable.run();
        }
    }

    private void processDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        IResource[] removedObjects;
        int i;
        IResource[] addedObjects;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x4000) != 0) {
            if (resource.isAccessible()) {
                runnables.add(this.getUpdateRunnable(resource));
            } else {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
        }
        if ((changeFlags & 0x98000) != 0) {
            runnables.add(this.getUpdateRunnable(resource));
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        if ((changeFlags & 0x104) != 0) {
            IFile file;
            if (resource instanceof IFile && PythonPathHelper.isValidSourceFile(file = (IFile)resource)) {
                runnables.add(this.getRefreshRunnable(resource));
            }
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3], runnables);
            ++i3;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new IResource[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                IResourceDelta addedChild = addedChildren[i];
                addedObjects[i] = addedChild.getResource();
                if (this.checkInit(addedObjects[i], runnables)) {
                    return;
                }
                if ((addedChild.getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = this.EMPTY_RESOURCE_ARRAY;
        }
        if (removedChildren.length > 0) {
            removedObjects = new IResource[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                IResourceDelta removedChild = removedChildren[i];
                removedObjects[i] = removedChild.getResource();
                if (this.checkInit(removedObjects[i], runnables)) {
                    return;
                }
                if ((removedChild.getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = this.EMPTY_RESOURCE_ARRAY;
        }
        final boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = new Runnable(){

            public void run() {
                if (PythonBaseModelProvider.this.viewer instanceof AbstractTreeViewer) {
                    CommonViewer treeViewer = PythonBaseModelProvider.this.viewer;
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(false);
                    }
                    try {
                        IResource rem;
                        Object remInPythonModel;
                        IResource object;
                        int n;
                        int n2;
                        IResource[] iResourceArray;
                        HashSet<IProject> notifyRebuilt = new HashSet<IProject>();
                        if (addedObjects.length > 0) {
                            treeViewer.add((Object)resource, (Object[])addedObjects);
                            iResourceArray = addedObjects;
                            n2 = addedObjects.length;
                            n = 0;
                            while (n < n2) {
                                object = iResourceArray[n];
                                if (object instanceof IResource && (remInPythonModel = PythonBaseModelProvider.this.getResourceInPythonModel(rem = object, true)) instanceof PythonSourceFolder) {
                                    notifyRebuilt.add(rem.getProject());
                                }
                                ++n;
                            }
                        }
                        if (removedObjects.length > 0) {
                            treeViewer.remove((Object[])removedObjects);
                            iResourceArray = removedObjects;
                            n2 = removedObjects.length;
                            n = 0;
                            while (n < n2) {
                                object = iResourceArray[n];
                                if (object instanceof IResource && (remInPythonModel = PythonBaseModelProvider.this.getResourceInPythonModel(rem = object, true)) instanceof PythonSourceFolder) {
                                    notifyRebuilt.add(rem.getProject());
                                }
                                ++n;
                            }
                        }
                        for (IProject project : notifyRebuilt) {
                            PythonNature nature = PythonNature.getPythonNature(project);
                            if (nature == null) continue;
                            PythonBaseModelProvider.this.notifyPythonPathRebuilt(project, nature);
                        }
                    }
                    finally {
                        if (hasRename) {
                            treeViewer.getControl().setRedraw(true);
                        }
                    }
                } else {
                    PythonBaseModelProvider.this.viewer.refresh((Object)resource);
                }
            }
        };
        runnables.add(addAndRemove);
    }

    private boolean checkInit(IResource resource, Collection<Runnable> runnables) {
        String name;
        if (resource != null && (name = resource.getName()) != null) {
            String[] stringArray = FileTypesPreferencesPage.getValidInitFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String init = stringArray[n2];
                if (name.equals(init)) {
                    runnables.add(this.getRefreshRunnable((IResource)resource.getParent()));
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Runnable getRefreshRunnable(final IResource resource) {
        return new Runnable(){

            public void run() {
                PythonBaseModelProvider.this.viewer.refresh(PythonBaseModelProvider.this.getResourceInPythonModel(resource));
            }
        };
    }

    private Runnable getUpdateRunnable(final IResource resource) {
        return new Runnable(){

            public void run() {
                PythonBaseModelProvider.this.viewer.update(PythonBaseModelProvider.this.getResourceInPythonModel(resource), null);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Updater
    extends Job {
        private List<String> projectPythonpath;
        private IProject project;
        private Object updaterLock;

        public Updater() {
            super("Model provider updating pythonpath");
            this.updaterLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            List<String> projectPythonpathToUse;
            IProject projectToUse;
            Object object = this.updaterLock;
            synchronized (object) {
                projectToUse = this.project;
                projectPythonpathToUse = this.projectPythonpath;
                this.project = null;
                this.projectPythonpath = null;
            }
            if (projectToUse != null && projectPythonpathToUse != null) {
                PythonBaseModelProvider.this.internalDoNotifyPythonPathRebuilt(projectToUse, projectPythonpathToUse);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setNeededParameters(IProject project, List<String> projectPythonpath) {
            Object object = this.updaterLock;
            synchronized (object) {
                this.project = project;
                this.projectPythonpath = projectPythonpath;
            }
        }
    }
}

