/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.ZipStructure;
import org.python.pydev.navigator.elements.ISortedElement;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.ImageCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonpathZipChildTreeNode
extends TreeNode<LabelAndImage>
implements ISortedElement {
    private boolean calculated = false;
    public final boolean isDir;
    public final ZipStructure zipStructure;
    public final String zipPath;
    private boolean isPackage;
    private List<String> dirContents;

    public PythonpathZipChildTreeNode(TreeNode<LabelAndImage> parent, ZipStructure zipStructure, String zipPath, Image icon, boolean isPythonpathRoot) {
        super(parent, null);
        try {
            this.zipStructure = zipStructure;
            this.zipPath = zipPath;
            this.isDir = StringUtils.endsWith((String)zipPath, (char)'/');
            if (this.isDir) {
                this.dirContents = zipStructure.contents(zipPath);
                if (isPythonpathRoot) {
                    this.isPackage = true;
                } else if (parent instanceof PythonpathZipChildTreeNode && ((PythonpathZipChildTreeNode)parent).isPackage) {
                    for (String s : this.dirContents) {
                        if (!PythonPathHelper.isValidInitFile(s)) continue;
                        this.isPackage = true;
                        break;
                    }
                }
            }
            if (icon == null) {
                ImageCache imageCache = PydevPlugin.getImageCache();
                icon = this.isDir ? (this.isPackage ? imageCache.get("icons/package_obj.gif") : imageCache.get("icons/folder.gif")) : (PythonPathHelper.isValidSourceFile(zipPath) ? imageCache.get("icons/python_file.gif") : imageCache.get("icons/file.gif"));
            }
        }
        finally {
            this.setData(new LabelAndImage(PythonpathZipChildTreeNode.getLabel(zipPath), icon));
        }
    }

    private static String getLabel(String zipPath) {
        int lastIndexOf;
        if (StringUtils.endsWith((String)zipPath, (char)'/')) {
            zipPath = zipPath.substring(0, zipPath.length() - 1);
        }
        if ((lastIndexOf = zipPath.lastIndexOf(47)) == -1) {
            return zipPath;
        }
        return zipPath.substring(lastIndexOf + 1);
    }

    public boolean hasChildren() {
        return this.isDir && this.dirContents != null && this.dirContents.size() > 0;
    }

    @Override
    public int getRank() {
        return this.isDir ? 1 : 3;
    }

    public synchronized List<TreeNode<LabelAndImage>> getChildren() {
        if (!this.calculated) {
            this.calculated = true;
            if (this.isDir && this.dirContents != null) {
                for (String childPath : this.dirContents) {
                    new PythonpathZipChildTreeNode(this, this.zipStructure, childPath, null, false);
                }
            }
        }
        return super.getChildren();
    }
}

