/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.io.FileUtils;

public abstract class AbstractPythonNature
implements IPythonNature {
    private final Stack<IModulesManager> modulesManagerStack = new Stack();
    private final Object modulesManagerStackLock = new Object();

    public boolean isResourceInPythonpath(IResource resource) throws MisconfigurationException {
        return this.resolveModule(resource) != null;
    }

    public boolean isResourceInPythonpath(String absPath) throws MisconfigurationException {
        return this.resolveModule(absPath) != null;
    }

    public String resolveModule(IResource resource) throws MisconfigurationException {
        String resourceOSString = PydevPlugin.getIResourceOSString(resource);
        if (resourceOSString == null) {
            return null;
        }
        return this.resolveModule(resourceOSString);
    }

    public String resolveModule(File file) throws MisconfigurationException {
        return this.resolveModule(FileUtils.getFileAbsolutePath((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRequests() {
        ICodeCompletionASTManager astManager = this.getAstManager();
        if (astManager == null) {
            return false;
        }
        IModulesManager modulesManager = astManager.getModulesManager();
        if (modulesManager == null) {
            return false;
        }
        Object object = this.modulesManagerStackLock;
        synchronized (object) {
            this.modulesManagerStack.push(modulesManager);
            return modulesManager.startCompletionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequests() {
        Object object = this.modulesManagerStackLock;
        synchronized (object) {
            try {
                IModulesManager modulesManager = this.modulesManagerStack.pop();
                modulesManager.endCompletionCache();
            }
            catch (EmptyStackException e) {
                Log.log((Throwable)e);
            }
        }
    }
}

