/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.JavaVmLocationFinder;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJythonRunner
extends SimpleRunner {
    public Tuple<String, String> runAndGetOutputWithJar(String script, String jythonJar, String[] args, File workingDir, IProject project, IProgressMonitor monitor, String encoding) {
        File javaExecutable = JavaVmLocationFinder.findDefaultJavaExecutable();
        if (javaExecutable == null) {
            throw new JavaNotConfiguredException("Error: the java environment must be configured before jython.\n\nPlease make sure that the java executable to be\nused is correctly configured in the preferences at:\n\nJava > Installed JREs.");
        }
        return this.runAndGetOutputWithJar(javaExecutable, script, jythonJar, args, workingDir, project, monitor, null, encoding);
    }

    public Tuple<String, String> runAndGetOutputWithJar(File javaExecutable, String script, String jythonJar, String[] args, File workingDir, IProject project, IProgressMonitor monitor, String additionalPythonpath, String encoding) {
        try {
            String[] s;
            String javaLoc = javaExecutable.getCanonicalPath();
            String pythonHome = new File(jythonJar).getParent().toString();
            if (additionalPythonpath != null) {
                jythonJar = String.valueOf(jythonJar) + SimpleRunner.getPythonPathSeparator();
                jythonJar = String.valueOf(jythonJar) + additionalPythonpath;
                s = new String[]{javaLoc, "-Dpython.path=" + additionalPythonpath, "-Dpython.home=" + pythonHome, "-classpath", jythonJar, "org.python.util.jython", script};
            } else {
                s = new String[]{javaLoc, "-Dpython.home=" + pythonHome, "-classpath", jythonJar, "org.python.util.jython", script};
            }
            if (args != null && args.length > 0) {
                s = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{s, args});
            }
            return this.runAndGetOutput(s, workingDir, PythonNature.getPythonNature(project), monitor, encoding);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] makeExecutableCommandStr(String jythonJar, String script, String basePythonPath, String ... args) throws IOException, JDTNotAvailableException, MisconfigurationException {
        return SimpleJythonRunner.makeExecutableCommandStrWithVMArgs(jythonJar, script, basePythonPath, "", args);
    }

    public static String[] makeExecutableCommandStrWithVMArgs(String jythonJar, String script, String basePythonPath, String vmArgs, String ... args) throws IOException, JDTNotAvailableException, MisconfigurationException {
        IInterpreterManager interpreterManager = PydevPlugin.getJythonInterpreterManager();
        String javaLoc = JavaVmLocationFinder.findDefaultJavaExecutable().getCanonicalPath();
        File file = new File(javaLoc);
        if (!file.exists()) {
            throw new RuntimeException("The java location found does not exist. " + javaLoc);
        }
        if (file.isDirectory()) {
            throw new RuntimeException("The java location found is a directory. " + javaLoc);
        }
        if (!new File(jythonJar).exists()) {
            throw new RuntimeException(StringUtils.format((String)"Error. The default configured interpreter: %s does not exist!", (Object[])new Object[]{jythonJar}));
        }
        InterpreterInfo info = (InterpreterInfo)interpreterManager.getInterpreterInfo(jythonJar, (IProgressMonitor)new NullProgressMonitor());
        String libs = SimpleRunner.makePythonPathEnvFromPaths(info.libs);
        FastStringBuffer jythonPath = new FastStringBuffer(basePythonPath, 128);
        String pathSeparator = SimpleRunner.getPythonPathSeparator();
        if (jythonPath.length() != 0) {
            jythonPath.append(pathSeparator);
        }
        jythonPath.append(libs);
        String cacheDir = null;
        try {
            cacheDir = PydevPrefs.getChainedPrefStore().getString("JYTHON_CACHE_DIR");
        }
        catch (NullPointerException nullPointerException) {
            cacheDir = null;
        }
        if (cacheDir != null && cacheDir.trim().length() == 0) {
            cacheDir = null;
        }
        if (cacheDir != null) {
            cacheDir = "-Dpython.cachedir=" + cacheDir.trim();
        }
        String[] s = cacheDir != null ? new String[]{javaLoc, cacheDir, "-Dpython.path=" + jythonPath.toString(), "-classpath", String.valueOf(jythonJar) + pathSeparator + jythonPath, vmArgs, "org.python.util.jython", script} : new String[]{javaLoc, "-Dpython.path=" + jythonPath.toString(), "-classpath", String.valueOf(jythonJar) + pathSeparator + jythonPath, vmArgs, "org.python.util.jython", script};
        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(s));
        asList.addAll(Arrays.asList(args));
        return asList.toArray(new String[0]);
    }

    public static class JavaNotConfiguredException
    extends RuntimeException {
        public JavaNotConfiguredException(String string) {
            super(string);
        }
    }
}

