/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.resources;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;
import org.python.pydev.shared_ui.EditorUtils;

public abstract class PyResourceAction {
    protected List<IResource> selectedResources;

    protected boolean getRefreshBeforeExecute() {
        return true;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.selectedResources = null;
            return;
        }
        IStructuredSelection selections = (IStructuredSelection)selection;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Object o : selections) {
            IAdaptable adaptable;
            IResource resource;
            if (o instanceof IResource) {
                resources.add((IResource)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (resource = (IResource)(adaptable = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            resources.add(resource);
        }
        this.selectedResources = resources;
    }

    public void run(IAction action) {
        if (this.selectedResources == null) {
            return;
        }
        if (!this.confirmRun()) {
            return;
        }
        this.beforeRun();
        final Integer[] nChanged = new Integer[]{0};
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(EditorUtils.getShell());
        try {
            IRunnableWithProgress operation = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    for (IResource next : PyResourceAction.this.selectedResources) {
                        if (PyResourceAction.this.getRefreshBeforeExecute()) {
                            try {
                                next.refreshLocal(2, monitor);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                        nChanged[0] = nChanged[0] + PyResourceAction.this.doActionOnResource(next, monitor);
                    }
                }
            };
            boolean fork = !this.needsUIThread();
            monitorDialog.run(fork, true, operation);
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        this.afterRun(nChanged[0]);
    }

    protected void beforeRun() {
    }

    protected abstract boolean confirmRun();

    protected boolean needsUIThread() {
        return false;
    }

    protected abstract void afterRun(int var1);

    protected abstract int doActionOnResource(IResource var1, IProgressMonitor var2);
}

