/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabNannyDocIterator {
    private int offset;
    private Tuple3<String, Integer, Boolean> nextString;
    private boolean firstPass = true;
    private final ParsingUtils parsingUtils;
    private final FastStringBuffer tempBuf = new FastStringBuffer();
    private final boolean yieldEmptyIndents;
    private final boolean yieldOnLinesWithoutContents;
    private final IDocument doc;

    public TabNannyDocIterator(IDocument doc) throws BadLocationException {
        this(doc, false, true);
    }

    public TabNannyDocIterator(IDocument doc, boolean yieldEmptyIndents, boolean yieldOnLinesWithoutContents) throws BadLocationException {
        this.parsingUtils = ParsingUtils.create((Object)doc, (boolean)true);
        this.doc = doc;
        this.yieldEmptyIndents = yieldEmptyIndents;
        this.yieldOnLinesWithoutContents = yieldOnLinesWithoutContents;
        this.buildNext(true);
    }

    public boolean hasNext() {
        return this.nextString != null;
    }

    public Tuple3<String, Integer, Boolean> next() throws BadLocationException {
        if (!this.hasNext()) {
            throw new RuntimeException("Cannot iterate anymore.");
        }
        Tuple3<String, Integer, Boolean> ret = this.nextString;
        this.buildNext(false);
        return ret;
    }

    private void buildNext(boolean first) throws BadLocationException {
        while (!this.internalBuildNext()) {
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean internalBuildNext() throws BadLocationException {
        try {
            char c = '\u0000';
            int initial = -1;
            while (true) {
                if (initial == -1) {
                    initial = this.offset;
                } else {
                    if (initial == this.offset) {
                        Log.log((String)("Error: TabNannyDocIterator didn't walk.\nCurr char:" + c + "\n" + "Curr char (as int):" + c + "\n" + "Offset:" + this.offset + "\n" + "DocLen:" + this.doc.getLength() + "\n"));
                        ++this.offset;
                        return true;
                    }
                    initial = this.offset;
                }
                if (this.offset >= this.doc.getLength()) {
                    this.nextString = null;
                    return true;
                }
                c = this.doc.getChar(this.offset);
                if (this.firstPass) {
                    this.firstPass = false;
                    if (c == 32 || c == '\t') break;
                    if (this.yieldEmptyIndents) {
                        this.nextString = new Tuple3((Object)this.tempBuf.toString(), (Object)this.offset, (Object)(c != '\r' && c != '\n' ? 1 : 0));
                        if (this.yieldOnLinesWithoutContents) return true;
                        if ((Boolean)this.nextString.o3 != false) return true;
                        return false;
                    }
                }
                if (c == '#') {
                    this.offset = this.parsingUtils.eatComments(null, this.offset);
                    continue;
                }
                if (c == '{' || c == '[' || c == '(') {
                    try {
                        this.offset = this.parsingUtils.eatPar(this.offset, null, c);
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                        ++this.offset;
                    }
                    continue;
                }
                if (c == '\r') {
                    if (!this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    c = this.doc.getChar(this.offset);
                    if (c != 10 || this.continueAfterIncreaseOffset()) break;
                    return true;
                }
                if (c == '\n') {
                    if (this.continueAfterIncreaseOffset()) break;
                    return true;
                }
                if (c == '\\') {
                    boolean lastLineChar = false;
                    if (!this.continueAfterIncreaseOffset()) {
                        return true;
                    }
                    c = this.doc.getChar(this.offset);
                    if (c == '\r') {
                        if (!this.continueAfterIncreaseOffset()) {
                            return true;
                        }
                        c = this.doc.getChar(this.offset);
                        lastLineChar = true;
                    }
                    if (c == '\n') {
                        if (!this.continueAfterIncreaseOffset()) {
                            return true;
                        }
                        lastLineChar = true;
                    }
                    if (lastLineChar) continue;
                    break;
                }
                if (c == '\'' || c == '\"') {
                    try {
                        this.offset = this.parsingUtils.getLiteralEnd(this.offset, c) + 1;
                    }
                    catch (SyntaxErrorException syntaxErrorException) {
                        ++this.offset;
                    }
                    continue;
                }
                if (!this.continueAfterIncreaseOffset()) return true;
            }
            if (this.offset >= this.doc.getLength()) {
                this.nextString = null;
                return true;
            }
            c = this.doc.getChar(this.offset);
            this.tempBuf.clear();
            int startingOffset = this.offset;
            while (c == ' ' || c == '\t') {
                this.tempBuf.append(c);
                ++this.offset;
                if (this.offset >= this.doc.getLength()) break;
                c = this.doc.getChar(this.offset);
            }
            this.nextString = new Tuple3((Object)this.tempBuf.toString(), (Object)startingOffset, (Object)(c != '\r' && c != '\n' ? 1 : 0));
            if (!this.yieldOnLinesWithoutContents && !((Boolean)this.nextString.o3).booleanValue()) {
                return false;
            }
            if (((String)this.nextString.o1).length() != 0) return true;
            if (!this.yieldEmptyIndents) return false;
            return true;
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof BadLocationException)) throw e;
            throw (BadLocationException)e.getCause();
        }
    }

    private boolean continueAfterIncreaseOffset() {
        ++this.offset;
        boolean ret = true;
        if (this.offset >= this.doc.getLength()) {
            this.nextString = null;
            ret = false;
        }
        return ret;
    }

    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

