/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;

public final class Call
extends exprType {
    public exprType func;
    public exprType[] args;
    public keywordType[] keywords;
    public exprType starargs;
    public exprType kwargs;

    public Call(exprType func, exprType[] args, keywordType[] keywords, exprType starargs, exprType kwargs) {
        this.func = func;
        this.args = args;
        this.keywords = keywords;
        this.starargs = starargs;
        this.kwargs = kwargs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.func == null ? 0 : this.func.hashCode());
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + Arrays.hashCode(this.keywords);
        result = 31 * result + (this.starargs == null ? 0 : this.starargs.hashCode());
        result = 31 * result + (this.kwargs == null ? 0 : this.kwargs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Call other = (Call)obj;
        if (this.func == null ? other.func != null : !this.func.equals(other.func)) {
            return false;
        }
        if (!Arrays.equals(this.args, other.args)) {
            return false;
        }
        if (!Arrays.equals(this.keywords, other.keywords)) {
            return false;
        }
        if (this.starargs == null ? other.starargs != null : !this.starargs.equals(other.starargs)) {
            return false;
        }
        return !(this.kwargs == null ? other.kwargs != null : !this.kwargs.equals(other.kwargs));
    }

    public Call createCopy() {
        return this.createCopy(true);
    }

    public Call createCopy(boolean copyComments) {
        commentType commentType2;
        keywordType[] new1;
        exprType[] new0;
        if (this.args != null) {
            new0 = new exprType[this.args.length];
            int i = 0;
            while (i < this.args.length) {
                new0[i] = (exprType)(this.args[i] != null ? this.args[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.args;
        }
        if (this.keywords != null) {
            new1 = new keywordType[this.keywords.length];
            int i = 0;
            while (i < this.keywords.length) {
                new1[i] = this.keywords[i] != null ? this.keywords[i].createCopy(copyComments) : null;
                ++i;
            }
        } else {
            new1 = this.keywords;
        }
        Call temp = new Call(this.func != null ? (exprType)this.func.createCopy(copyComments) : null, new0, new1, this.starargs != null ? (exprType)this.starargs.createCopy(copyComments) : null, this.kwargs != null ? (exprType)this.kwargs.createCopy(copyComments) : null);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Call[");
        sb.append("func=");
        sb.append(this.dumpThis(this.func));
        sb.append(", ");
        sb.append("args=");
        sb.append(this.dumpThis(this.args));
        sb.append(", ");
        sb.append("keywords=");
        sb.append(this.dumpThis(this.keywords));
        sb.append(", ");
        sb.append("starargs=");
        sb.append(this.dumpThis(this.starargs));
        sb.append(", ");
        sb.append("kwargs=");
        sb.append(this.dumpThis(this.kwargs));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitCall(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.func != null) {
            this.func.accept(visitor);
        }
        if (this.args != null) {
            i = 0;
            while (i < this.args.length) {
                if (this.args[i] != null) {
                    this.args[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.keywords != null) {
            i = 0;
            while (i < this.keywords.length) {
                if (this.keywords[i] != null) {
                    this.keywords[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.starargs != null) {
            this.starargs.accept(visitor);
        }
        if (this.kwargs != null) {
            this.kwargs.accept(visitor);
        }
    }
}

