/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast.factory;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.NodeHelper;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.structure.FastStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyAstFactory {
    NodeHelper nodeHelper;
    private static final RuntimeException stopVisitingException = new RuntimeException("stop visiting");

    public PyAstFactory(AdapterPrefs adapterPrefs) {
        this.nodeHelper = new NodeHelper(adapterPrefs);
    }

    public FunctionDef createFunctionDef(String name) {
        FunctionDef functionDef = new FunctionDef(new NameTok(name, 2), null, null, null, null);
        return functionDef;
    }

    public ClassDef createClassDef(String name) {
        exprType[] bases = null;
        stmtType[] body = null;
        decoratorsType[] decs = null;
        keywordType[] keywords = null;
        exprType starargs = null;
        exprType kwargs = null;
        ClassDef def = new ClassDef(new NameTok(name, 1), bases, body, decs, keywords, starargs, kwargs);
        return def;
    }

    public void setBaseClasses(ClassDef classDef, String ... baseClasses) {
        ArrayList<Name> bases = new ArrayList<Name>();
        String[] stringArray = baseClasses;
        int n = baseClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Name n3 = this.createName(s);
            bases.add(n3);
            ++n2;
        }
        classDef.bases = bases.toArray(new exprType[bases.size()]);
    }

    public Name createName(String s) {
        Name name = new Name(s, 1, false);
        return name;
    }

    public FunctionDef createSetterFunctionDef(String accessorName, String attributeName) {
        NameTok functionName = new NameTok(accessorName, 2);
        argumentsType args = this.createArguments(true, "value");
        stmtType[] body = this.createSetterBody(attributeName);
        return new FunctionDef(functionName, args, body, null, null);
    }

    public argumentsType createArguments(boolean addSelf, String ... simpleParams) {
        ArrayList<Name> params = new ArrayList<Name>();
        if (addSelf) {
            params.add(new Name("self", 6, true));
        }
        String[] stringArray = simpleParams;
        int n = simpleParams.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            params.add(new Name(s, 6, false));
            ++n2;
        }
        return new argumentsType(params.toArray(new exprType[params.size()]), null, null, null, null, null, null, null, null, null);
    }

    private stmtType[] createSetterBody(String attributeName) {
        Name self = new Name("self", 1, true);
        NameTok name = new NameTok(this.nodeHelper.getPrivateAttr(attributeName), 8);
        Attribute attribute = new Attribute(self, name, 2);
        Name value = new Name("value", 1, false);
        Assign assign = new Assign(new exprType[]{attribute}, value);
        return new stmtType[]{assign};
    }

    public Call createCall(String call, String ... params) {
        List<exprType> lst = this.createParamsList(params);
        return this.createCall(call, lst, null, null, null);
    }

    public List<exprType> createParamsList(String ... params) {
        ArrayList<exprType> lst = new ArrayList<exprType>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            lst.add(new Name(p, 6, false));
            ++n2;
        }
        return lst;
    }

    public Call createCall(String call, List<exprType> params, keywordType[] keywords, exprType starargs, exprType kwargs) {
        exprType[] array;
        exprType[] exprTypeArray = array = params != null ? (exprType[])params.toArray(new Name[params.size()]) : new exprType[]{};
        if (call.indexOf(".") != -1) {
            return new Call(this.createAttribute(call), array, keywords, starargs, kwargs);
        }
        return new Call(new Name(call, 1, false), array, keywords, starargs, kwargs);
    }

    public Attribute createAttribute(String attribute) {
        List splitted = StringUtils.split((String)attribute, (char)'.');
        if (splitted.size() <= 1) {
            throw new RuntimeException("Cannot create attribute without dot access.");
        }
        if (splitted.size() == 2) {
            return new Attribute(new Name((String)splitted.get(0), 1, false), new NameTok((String)splitted.get(1), 8), 1);
        }
        return new Attribute(this.createAttribute(FullRepIterable.getWithoutLastPart((String)attribute)), new NameTok((String)splitted.get(splitted.size() - 1), 8), 1);
    }

    public Assign createAssign(exprType ... targetsAndVal) {
        exprType[] targets = new exprType[targetsAndVal.length - 1];
        System.arraycopy(targetsAndVal, 0, targets, 0, targets.length);
        exprType value = targetsAndVal[targetsAndVal.length - 1];
        return new Assign(targets, value);
    }

    public void setBody(FunctionDef functionDef, Object ... body) {
        functionDef.body = this.createStmtArray(body);
    }

    public void setBody(ClassDef def, Object ... body) {
        def.body = this.createStmtArray(body);
    }

    private stmtType[] createStmtArray(Object ... body) {
        ArrayList<stmtType> newBody = new ArrayList<stmtType>();
        Object[] objectArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof exprType) {
                newBody.add(new Expr((exprType)o));
            } else if (o instanceof stmtType) {
                newBody.add((stmtType)o);
            } else {
                throw new RuntimeException("Unhandled: " + o);
            }
            ++n2;
        }
        stmtType[] bodyArray = newBody.toArray(new stmtType[newBody.size()]);
        return bodyArray;
    }

    public Str createString(String string) {
        return new Str(string, 1, false, false, false);
    }

    public Pass createPass() {
        return new Pass();
    }

    public stmtType createOverrideBody(FunctionDef functionDef, String parentClassName, String currentClassName) {
        Call call;
        boolean[] addReturn;
        block15: {
            addReturn = new boolean[1];
            VisitorBase visitor = new VisitorBase(){

                public Object visitClassDef(ClassDef node) throws Exception {
                    return null;
                }

                public Object visitFunctionDef(FunctionDef node) throws Exception {
                    return null;
                }

                protected Object unhandled_node(SimpleNode node) throws Exception {
                    if (node instanceof Return) {
                        addReturn[0] = true;
                        throw stopVisitingException;
                    }
                    return null;
                }

                public void traverse(SimpleNode node) throws Exception {
                    node.traverse(this);
                }
            };
            try {
                visitor.traverse(functionDef);
            }
            catch (Exception e) {
                if (e == stopVisitingException) break block15;
                Log.log((Throwable)e);
            }
        }
        boolean isClassMethod = false;
        if (functionDef.decs != null) {
            decoratorsType[] decoratorsTypeArray = functionDef.decs;
            int n = functionDef.decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType dec = decoratorsTypeArray[n2];
                String rep = NodeUtils.getRepresentationString(dec.func);
                if ("classmethod".equals(rep)) {
                    isClassMethod = true;
                    break;
                }
                ++n2;
            }
        }
        argumentsType args = functionDef.args.createCopy(false);
        ArrayList<exprType> params = new ArrayList<exprType>();
        exprType[] exprTypeArray = args.args;
        int rep = args.args.length;
        int n = 0;
        while (n < rep) {
            exprType expr = exprTypeArray[n];
            params.add(expr);
            ++n;
        }
        Name starargs = args.vararg != null ? new Name(((NameTok)args.vararg).id, 1, false) : null;
        Name kwargs = args.kwarg != null ? new Name(((NameTok)args.kwarg).id, 1, false) : null;
        ArrayList<keywordType> keywords = new ArrayList<keywordType>();
        if (args.defaults != null) {
            int diff = args.args.length - args.defaults.length;
            FastStack removePositions = new FastStack(args.defaults.length);
            int i = 0;
            while (i < args.defaults.length) {
                exprType expr = args.defaults[i];
                if (expr != null) {
                    exprType name = (exprType)params.get(i + diff);
                    if (name instanceof Name) {
                        removePositions.push((Object)(i + diff));
                        keywords.add(new keywordType(new NameTok(((Name)name).id, 3), name, false));
                    } else {
                        Log.log((String)("Expected: " + name + " to be a Name instance."));
                    }
                }
                ++i;
            }
            while (removePositions.size() > 0) {
                Integer pop = (Integer)removePositions.pop();
                params.remove(pop);
            }
        }
        if (isClassMethod && params.size() > 0) {
            exprType firstParam = (exprType)params.remove(0);
            Call innerCall = this.createCall("super", currentClassName, NodeUtils.getRepresentationString(firstParam));
            Attribute attr = new Attribute(innerCall, new NameTok(NodeUtils.getRepresentationString(functionDef), 8), 1);
            call = new Call(attr, params.toArray(new Name[params.size()]), keywords.toArray(new keywordType[keywords.size()]), starargs, kwargs);
        } else {
            call = this.createCall(String.valueOf(parentClassName) + "." + NodeUtils.getRepresentationString(functionDef), params, keywords.toArray(new keywordType[keywords.size()]), starargs, kwargs);
        }
        if (addReturn[0]) {
            return new Return(call);
        }
        return new Expr(call);
    }
}

