/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;

public class PythonModuleManager {
    private transient IPythonNature nature;
    private static boolean testingFlag = false;

    public PythonModuleManager(IPythonNature nature) {
        this.nature = nature;
    }

    public static IDocument getDocFromFile(File file) {
        boolean loadIfNotInWorkspace = !testingFlag;
        IDocument doc = null;
        try {
            doc = FileUtilsFileBuffer.getDocFromFile((File)file, (boolean)loadIfNotInWorkspace);
        }
        catch (IOException iOException) {}
        if (doc == null) {
            try {
                doc = new Document(PythonModuleManager.getFileContent(new FileInputStream(file)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return doc;
    }

    private static String getFileContent(InputStream stream) {
        if (!testingFlag) {
            throw new RuntimeException("Should only call this method in tests.");
        }
        try {
            String line;
            StringBuilder contentBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
            while ((line = bufferedReader.readLine()) != null) {
                contentBuilder.append(line).append('\n');
            }
            return contentBuilder.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public IModulesManager getIModuleManager() {
        return this.nature.getAstManager().getModulesManager();
    }

    public static boolean isTesting() {
        return testingFlag;
    }

    public static void setTesting(boolean testingFlag) {
        PythonModuleManager.testingFlag = testingFlag;
    }
}

