/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.renamer;

import java.util.HashMap;
import java.util.Map;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.NodeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVarRenameVisitor
extends VisitorBase {
    private Map<String, String> renameMap = new HashMap<String, String>();
    private NodeHelper nodeHelper;

    public LocalVarRenameVisitor(AdapterPrefs adapterPrefs) {
        this.nodeHelper = new NodeHelper(adapterPrefs);
    }

    public void visit(SimpleNode node) throws Exception {
        if (node == null) {
            return;
        }
        if (this.nodeHelper.isFunctionOrClassDef(node)) {
            return;
        }
        node.accept((VisitorIF)this);
    }

    public void traverse(SimpleNode node) throws Exception {
        if (node != null) {
            node.traverse((VisitorIF)this);
        }
    }

    public Object visitName(Name node) throws Exception {
        if (this.renameMap.containsKey(node.id)) {
            node.id = this.renameMap.get(node.id);
        }
        return null;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        if (this.renameMap.containsKey(node.id)) {
            node.id = this.renameMap.get(node.id);
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        this.visit(node.args);
        this.visit((SimpleNode[])node.body);
        return null;
    }

    private void visit(argumentsType args) throws Exception {
        this.visit((SimpleNode[])args.args);
        this.visit((SimpleNode)args.vararg);
        this.visit((SimpleNode)args.kwarg);
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.visit((SimpleNode)node.value);
        return null;
    }

    private void visit(SimpleNode[] nodes) throws Exception {
        SimpleNode[] simpleNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode node = simpleNodeArray[n2];
            this.visit(node);
            ++n2;
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public void setRenameMap(Map<String, String> renameMap) {
        this.renameMap = renameMap;
    }
}

