/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import java.util.ListResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

public class RemoveCoverageMarkersListener
implements IDocumentListener,
IPyEditListener {
    private IDocument doc;
    private PyEdit edit;
    private IFile file;

    public RemoveCoverageMarkersListener(IDocument document, PyEdit edit, IFile file) {
        this.doc = document;
        this.edit = edit;
        this.file = file;
        document.addDocumentListener((IDocumentListener)this);
        edit.addPyeditListener((IPyEditListener)this);
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
        this.removeMarkersAndStopListening();
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
        this.removeMarkersAndStopListening();
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
        this.removeMarkersAndStopListening();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.removeMarkersAndStopListening();
    }

    private void removeMarkersAndStopListening() {
        PyMarkerUtils.removeMarkers((IResource)this.file, (String)"org.python.pydev.debug.pydev_coverage_marker");
        this.doc.removeDocumentListener((IDocumentListener)this);
        this.edit.removePyeditListener((IPyEditListener)this);
    }
}

