/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.core;

import java.io.File;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.python.pydev.debug.newconsole.prefs.ColorManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_ui.ImageCache;

public class PydevDebugPlugin
extends AbstractUIPlugin {
    private static PydevDebugPlugin plugin;
    public ImageCache imageCache;

    public PydevDebugPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.imageCache = new ImageCache(PydevDebugPlugin.getDefault().getBundle().getEntry("/"));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ColorManager.getDefault().dispose();
        this.imageCache.dispose();
    }

    public static PydevDebugPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        PydevDebugPlugin d = PydevDebugPlugin.getDefault();
        if (d == null) {
            return "Unable to get id";
        }
        return d.getBundle().getSymbolicName();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static ImageCache getImageCache() {
        return PydevDebugPlugin.plugin.imageCache;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PydevDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, PydevDebugPlugin.getPluginID(), errorLevel, message, e);
    }

    public static void log(int errorLevel, String message, Throwable e) {
        Status s = PydevDebugPlugin.makeStatus(errorLevel, message, e);
        PydevDebugPlugin.getDefault().getLog().log((IStatus)s);
    }

    public static void errorDialog(final String message, final Throwable t) {
        Display disp = Display.getDefault();
        disp.asyncExec(new Runnable(){

            public void run() {
                Shell shell;
                IWorkbenchWindow window = PydevDebugPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                Shell shell2 = shell = window == null ? null : window.getShell();
                if (shell != null) {
                    Status status = PydevDebugPlugin.makeStatus(4, "Error logged from Pydev Debug: ", t);
                    ErrorDialog.openError((Shell)shell, (String)"Its an error", (String)message, (IStatus)status);
                }
            }
        });
        PydevDebugPlugin.log(4, message, t);
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        return PydevPlugin.getScriptWithinPySrc((String)targetExec);
    }

    public static File getPySrcPath() throws CoreException {
        return PydevPlugin.getPySrcPath();
    }
}

