/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PyStackFrameConsole;
import org.python.pydev.debug.model.PyThreadConsole;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.RemoteDebuggerConsole;
import org.python.pydev.debug.model.remote.VersionCommand;
import org.python.pydev.debug.newconsole.IPydevConsoleDebugTarget;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsoleManager;

public class PyDebugTargetConsole
extends PyDebugTarget
implements IPydevConsoleDebugTarget {
    PyThreadConsole thread;
    IThread[] threads;
    private final PydevConsoleCommunication scriptConsoleCommunication;
    private ScriptConsole console;

    public PyDebugTargetConsole(PydevConsoleCommunication scriptConsoleCommunication, ILaunch launch, IProcess process, RemoteDebuggerConsole debugger) {
        super(launch, process, null, debugger, null);
        this.scriptConsoleCommunication = scriptConsoleCommunication;
        this.thread = new PyThreadConsole(this);
        this.threads = new IThread[]{this.thread};
    }

    public RemoteDebuggerConsole getDebugger() {
        return (RemoteDebuggerConsole)super.getDebugger();
    }

    public IThread[] getThreads() throws DebugException {
        if (this.isTerminated()) {
            return new IThread[0];
        }
        return this.threads;
    }

    private IStackFrame[] createFrames() {
        PyStackFrameConsole frame = new PyStackFrameConsole(this.thread, this);
        return new IStackFrame[]{frame};
    }

    public void setSuspended(boolean suspended) {
        if (suspended != this.thread.isSuspended()) {
            int state;
            if (suspended) {
                state = 2;
                this.thread.setSuspended(true, this.createFrames());
            } else {
                state = 1;
                this.thread.setSuspended(false, null);
            }
            this.fireEvent(new DebugEvent((Object)this.thread, state, 32));
        }
    }

    public String getName() throws DebugException {
        if (this.console == null) {
            return "PyDev Console";
        }
        return this.console.getName();
    }

    public void initialize() {
        this.postCommand(new VersionCommand(this));
        this.setSuspended(true);
    }

    public void postCommand(AbstractDebuggerCommand cmd) {
        try {
            this.scriptConsoleCommunication.postCommand(cmd);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void terminate() {
        super.terminate();
        if (this.console != null) {
            ScriptConsoleManager.getInstance().close(this.console);
        }
    }

    public void setConsole(ScriptConsole console) {
        this.console = console;
    }
}

