/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.python.pydev.core.IPyStackFrame;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.AdapterDebug;
import org.python.pydev.debug.model.DeferredWorkbenchAdapter;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.remote.AbstractDebuggerCommand;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.GetFileContentsCommand;
import org.python.pydev.debug.model.remote.GetFrameCommand;
import org.python.pydev.debug.model.remote.GetVariableCommand;
import org.python.pydev.debug.model.remote.ICommandResponseListener;
import org.python.pydev.editorinput.PySourceLocatorPrefs;

public class PyStackFrame
extends PlatformObject
implements IStackFrame,
IVariableLocator,
IPyStackFrame {
    private String name;
    private PyThread thread;
    private String id;
    private IPath path;
    private int line;
    private volatile IVariable[] variables;
    private IVariableLocator localsLocator;
    private IVariableLocator globalsLocator;
    private IVariableLocator frameLocator;
    private IVariableLocator expressionLocator;
    private AbstractDebugTarget target;
    private volatile boolean onAskGetNewVars = true;
    private static final IVariable[] EMPTY_VARIABLES = new IVariable[0];
    private static final Object lock = new Object();
    private String fileContents = null;

    public PyStackFrame(PyThread in_thread, String in_id, String name, IPath file, int line, AbstractDebugTarget target) {
        this.id = in_id;
        this.name = name;
        this.path = file;
        this.line = line;
        this.thread = in_thread;
        this.localsLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tLOCAL";
            }
        };
        this.frameLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tFRAME";
            }
        };
        this.globalsLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tGLOBAL";
            }
        };
        this.expressionLocator = new IVariableLocator(){

            public String getPyDBLocation() {
                return String.valueOf(PyStackFrame.this.thread.getId()) + "\t" + PyStackFrame.this.id + "\tEXPRESSION";
            }
        };
        this.target = target;
    }

    public AbstractDebugTarget getTarget() {
        return this.target;
    }

    public String getId() {
        return this.id;
    }

    public String getThreadId() {
        return this.thread.getId();
    }

    public IVariableLocator getLocalsLocator() {
        return this.localsLocator;
    }

    public IVariableLocator getFrameLocator() {
        return this.frameLocator;
    }

    public IVariableLocator getGlobalLocator() {
        return this.globalsLocator;
    }

    public IVariableLocator getExpressionLocator() {
        return this.expressionLocator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public IPath getPath() {
        return this.path;
    }

    public IThread getThread() {
        return this.thread;
    }

    public void setVariables(IVariable[] locals) {
        this.variables = locals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVariable[] getVariables() throws DebugException {
        if (this.onAskGetNewVars) {
            Object object = lock;
            synchronized (object) {
                if (this.onAskGetNewVars) {
                    IVariable[] oldVars = this.variables;
                    if (oldVars == null) {
                        this.variables = EMPTY_VARIABLES;
                    }
                    this.onAskGetNewVars = false;
                    DeferredWorkbenchAdapter adapter = new DeferredWorkbenchAdapter(this);
                    IVariable[] vars = (IVariable[])adapter.getChildren(this);
                    if (oldVars != null) {
                        this.target.getModificationChecker().verifyVariablesModified(vars, oldVars);
                    } else {
                        this.target.getModificationChecker().verifyModified(this, vars);
                    }
                    this.variables = vars;
                }
            }
        }
        return this.variables;
    }

    public IVariable[] getInternalVariables() {
        return this.variables;
    }

    public void forceGetNewVariables() {
        this.onAskGetNewVars = true;
        AbstractDebugTarget target = this.getTarget();
        if (target != null) {
            target.fireEvent(new DebugEvent((Object)this, 16, 512));
        }
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }

    public int getLineNumber() throws DebugException {
        return this.line;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return String.valueOf(this.name) + " [" + this.path.lastSegment() + ":" + Integer.toString(this.line) + "]";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getModelIdentifier() {
        return this.thread.getModelIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.thread.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.thread.getLaunch();
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public Object getAdapter(Class adapter) {
        AdapterDebug.print(this, adapter);
        if (adapter.equals(ILaunch.class) || adapter.equals(IResource.class)) {
            return this.thread.getAdapter(adapter);
        }
        if (adapter.equals(ITaskListResourceAdapter.class)) {
            return null;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this.thread.getDebugTarget();
        }
        if (adapter.equals(IRunToLineTarget.class)) {
            return this.target.getRunToLineTarget();
        }
        if (adapter.equals(IPropertySource.class) || adapter.equals(ITaskListResourceAdapter.class) || adapter.equals(IToggleBreakpointsTarget.class)) {
            return super.getAdapter(adapter);
        }
        if (adapter.equals(IDeferredWorkbenchAdapter.class)) {
            return new DeferredWorkbenchAdapter(this);
        }
        AdapterDebug.printDontKnow(this, adapter);
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PyStackFrame) {
            PyStackFrame sf = (PyStackFrame)obj;
            return this.id.equals(sf.id) && this.path.toString().equals(sf.path.toString()) && this.line == sf.line && this.getThreadId().equals(sf.getThreadId());
        }
        return false;
    }

    public GetVariableCommand getFrameCommand(AbstractDebugTarget dbg) {
        return new GetFrameCommand(dbg, this.frameLocator.getPyDBLocation());
    }

    public String getPyDBLocation() {
        return this.frameLocator.getPyDBLocation();
    }

    public AbstractRemoteDebugger getDebugger() {
        return this.target.getDebugger();
    }

    public String toString() {
        return "PyStackFrame: " + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents() {
        if (this.fileContents == null) {
            GetFileContentsCommand cmd = new GetFileContentsCommand(this.target, this.path.toOSString());
            final Object lock = new Object();
            final String[] response = new String[1];
            cmd.setCompletionListener(new ICommandResponseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void commandComplete(AbstractDebuggerCommand cmd) {
                    try {
                        response[0] = ((GetFileContentsCommand)cmd).getResponse();
                    }
                    catch (CoreException coreException) {
                        response[0] = "";
                    }
                    try {
                        Object object = lock;
                        synchronized (object) {
                            lock.notify();
                        }
                    }
                    catch (Exception exception) {}
                }
            });
            this.target.postCommand(cmd);
            int timeout = PySourceLocatorPrefs.getFileContentsTimeout();
            long initialTimeMillis = System.currentTimeMillis();
            while (response[0] == null) {
                Object object = lock;
                synchronized (object) {
                    try {
                        lock.wait(50L);
                    }
                    catch (Exception exception) {}
                }
                if (System.currentTimeMillis() - initialTimeMillis > (long)timeout) break;
            }
            this.fileContents = response[0];
        }
        return this.fileContents;
    }
}

