/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;

public class PinHistoryAction
extends Action {
    private WeakReference<PyUnitView> view;
    private PyUnitTestRun currentTestRun;
    public final CallbackWithListeners<PyUnitTestRun> onRunSelected;

    public PinHistoryAction(PyUnitView pyUnitView) {
        this.view = new WeakReference<PyUnitView>(pyUnitView);
        this.setInitialTooltipText();
        this.setImageDescriptor(PydevDebugPlugin.getImageCache().getDescriptor("icons/pin.png"));
        this.setChecked(false);
        this.currentTestRun = null;
        this.onRunSelected = new CallbackWithListeners();
    }

    private void setInitialTooltipText() {
        this.setToolTipText("Click to mark the currently selected run as the base-run.");
    }

    public PyUnitTestRun getCurrentTestRun() {
        return this.currentTestRun;
    }

    public void run() {
        boolean worked = false;
        try {
            if (this.isChecked()) {
                if (this.view == null) {
                    return;
                }
                PyUnitView pyUnitView = (PyUnitView)((Object)this.view.get());
                if (pyUnitView == null) {
                    return;
                }
                PyUnitTestRun currentTestRun = pyUnitView.getCurrentTestRun();
                if (currentTestRun != null) {
                    worked = true;
                    this.onRunSelected.call((Object)currentTestRun);
                    this.currentTestRun = currentTestRun;
                    this.setImageDescriptor(PydevDebugPlugin.getImageCache().getDescriptor("icons/pin_arrow.png"));
                    this.setToolTipText("Currently pin: " + currentTestRun.name + ". Click again to unpin.");
                }
            }
        }
        finally {
            if (!worked) {
                this.setImageDescriptor(PydevDebugPlugin.getImageCache().getDescriptor("icons/pin.png"));
                this.setInitialTooltipText();
                this.setChecked(false);
                this.currentTestRun = null;
                this.onRunSelected.call((Object)this.currentTestRun);
            }
        }
    }
}

