/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTFontParser;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TTFont {
    public static final byte[] TABLE_POST = "post".getBytes();
    public static final byte[] TABLE_PREP = "prep".getBytes();
    public static final byte[] TABLE_LOCA = "loca".getBytes();
    public static final byte[] TABLE_GLYF = "glyf".getBytes();
    public static final byte[] TABLE_FGPM = "fpgm".getBytes();
    public static final byte[] TABLE_CVT = "cvt ".getBytes();
    public static final byte[] TABLE_OS2 = "OS/2".getBytes();
    public static final byte[] TABLE_NAME = "name".getBytes();
    public static final byte[] TABLE_MAXP = "maxp".getBytes();
    public static final byte[] TABLE_HMTX = "hmtx".getBytes();
    public static final byte[] TABLE_HHEA = "hhea".getBytes();
    public static final byte[] TABLE_HEAD = "head".getBytes();
    public static final byte[] TABLE_CMAP = "cmap".getBytes();
    public static final int ARG_1_AND_2_ARE_WORDS = 1;
    public static final int WE_HAVE_A_SCALE = 8;
    public static final int MORE_COMPONENTS = 32;
    public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    public static final int WE_HAVE_A_TWO_BY_TWO = 128;
    public static byte[][] SubsetTables = new byte[][]{TABLE_CMAP, TABLE_HEAD, TABLE_HHEA, TABLE_HMTX, TABLE_MAXP, TABLE_NAME, TABLE_OS2, TABLE_CVT, TABLE_FGPM, TABLE_GLYF, TABLE_LOCA, TABLE_PREP};
    private Map cmaps;
    private ILocator locator;
    private String fontFamilyName = null;
    private String psName = null;
    private TTFontHeader fontHeader;
    private TTHorizontalHeader horizontalHeader;
    private TTMetrics metrics;
    private TTNaming naming;
    private TTPostScriptInformation postScriptInformation;
    private int[] glyphWidths;
    private TTTable[] tables;
    private FontStyle fontStyle = FontStyle.REGULAR;

    public static TTFont createFromLocator(ILocator iLocator) throws IOException {
        TTFont tTFont = new TTFont();
        tTFont.setLocator(iLocator);
        tTFont.initializeFromLocator();
        return tTFont;
    }

    protected TTFont() {
    }

    protected Set addCompositeGlyphs(IRandomAccess iRandomAccess, int[] nArray, Set set) throws IOException, TrueTypeException {
        set.add(new Integer(0));
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.addCompositeGlyphs(iRandomAccess, nArray, hashSet, n);
        }
        return hashSet;
    }

    protected void addCompositeGlyphs(IRandomAccess iRandomAccess, int[] nArray, Set set, int n) throws IOException, TrueTypeException {
        if (nArray[n] == nArray[n + 1]) {
            return;
        }
        iRandomAccess.seek((long)nArray[n]);
        TTFontParser tTFontParser = new TTFontParser();
        short s = tTFontParser.readShort(iRandomAccess);
        if (s >= 0) {
            return;
        }
        iRandomAccess.seekBy(8L);
        while (true) {
            int n2 = tTFontParser.readUShort(iRandomAccess);
            int n3 = tTFontParser.readUShort(iRandomAccess);
            set.add(new Integer(n3));
            if ((n2 & 0x20) == 0) {
                return;
            }
            int n4 = (n2 & 1) != 0 ? 4 : 2;
            if ((n2 & 8) != 0) {
                n4 += 2;
            } else if ((n2 & 0x40) != 0) {
                n4 += 4;
            }
            if ((n2 & 0x80) != 0) {
                n4 += 8;
            }
            iRandomAccess.seekBy((long)n4);
        }
    }

    protected TTFont copySubset() {
        TTFont tTFont = new TTFont();
        ArrayList<TTTable> arrayList = new ArrayList<TTTable>();
        int n = 0;
        while (n < SubsetTables.length) {
            TTTable tTTable = this.getTable(SubsetTables[n]);
            if (tTTable != null) {
                arrayList.add(tTTable);
            }
            ++n;
        }
        tTFont.setTables(arrayList.toArray(new TTTable[0]));
        return tTFont;
    }

    protected void createGlyphTable(TTTable tTTable, TTTable tTTable2, IRandomAccess iRandomAccess, int[] nArray, Set set) throws IOException, TrueTypeException {
        int n = 0;
        Object object = set.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            if (n2 + 1 >= nArray.length) continue;
            n += nArray[n2 + 1] - nArray[n2];
        }
        n = n + 3 & 0xFFFFFFFC;
        object = new int[nArray.length];
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6;
            object[n4] = n3;
            if (set.contains(new Integer(n4)) && (n6 = nArray[n4 + 1] - (n5 = nArray[n4])) > 0) {
                iRandomAccess.seek((long)n5);
                iRandomAccess.read(byArray, n3, n6);
                n3 += n6;
            }
            ++n4;
        }
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        TTFontSerializer tTFontSerializer = new TTFontSerializer();
        tTFontSerializer.write_loca((IRandomAccess)randomAccessByteArray, (int[])object, this.getFontHeader().isShortLocationFormat());
        tTTable.setBytes(randomAccessByteArray.toByteArray());
        tTTable2.setBytes(byArray);
    }

    public TTFont createSubset(Set set) throws IOException, TrueTypeException {
        TTTable tTTable = this.getTable(TABLE_LOCA);
        int[] nArray = new TTFontParser().parseTable_loca(tTTable, this.getFontHeader().isShortLocationFormat());
        TTTable tTTable2 = this.getTable(TABLE_GLYF);
        IRandomAccess iRandomAccess = tTTable2.getRandomAccess();
        try {
            TTFont tTFont = this.copySubset();
            Set set2 = tTFont.addCompositeGlyphs(iRandomAccess, nArray, set);
            tTFont.createGlyphTable(tTTable, tTTable2, iRandomAccess, nArray, set2);
            TTFont tTFont2 = tTFont;
            return tTFont2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public Map getCMaps() throws TrueTypeException {
        if (this.cmaps == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.cmaps = tTFontParser.parseTable_cmap(this.getTable(TABLE_CMAP));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.cmaps;
    }

    public Map getCMapsAt(int n, int n2) throws TrueTypeException {
        String string = n + ":" + n2;
        Object object = this.getCMaps().get(string);
        if (object instanceof TTTable) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                Map map = tTFontParser.parseTable_cmap_subtable((TTTable)object);
                this.getCMaps().put(string, map);
                object = map;
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return (Map)object;
    }

    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    public TTFontHeader getFontHeader() throws TrueTypeException {
        if (this.fontHeader == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.fontHeader = tTFontParser.parseTable_head(this.getTable(TABLE_HEAD));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.fontHeader;
    }

    public String getFontName() {
        return this.getPsName();
    }

    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    public int getGlyphWidth(int n) throws TrueTypeException {
        if (n < this.getGlyphWidths().length) {
            return this.getGlyphWidths()[n];
        }
        return this.getGlyphWidths()[this.getGlyphWidths().length - 1];
    }

    protected int[] getGlyphWidths() throws TrueTypeException {
        if (this.glyphWidths == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.glyphWidths = tTFontParser.parseTable_hmtx(this.getTable(TABLE_HMTX), this.getHorizontalHeader().getNumberOfHMetrics());
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.glyphWidths;
    }

    public TTHorizontalHeader getHorizontalHeader() throws TrueTypeException {
        if (this.horizontalHeader == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.horizontalHeader = tTFontParser.parseTable_hhea(this.getTable(TABLE_HHEA));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.horizontalHeader;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public TTMetrics getMetrics() throws TrueTypeException {
        if (this.metrics == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.metrics = tTFontParser.parseTable_os2(this.getTable(TABLE_OS2));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.metrics;
    }

    public TTNaming getNaming() throws TrueTypeException {
        if (this.naming == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                TTTable tTTable = this.getTable(TABLE_NAME);
                if (tTTable != null) {
                    this.naming = tTFontParser.parseTable_name(tTTable);
                }
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.naming;
    }

    public TTPostScriptInformation getPostScriptInformation() throws TrueTypeException {
        if (this.postScriptInformation == null) {
            TTFontParser tTFontParser = new TTFontParser();
            try {
                this.postScriptInformation = tTFontParser.parseTable_post(this.getTable(TABLE_POST));
            }
            catch (IOException iOException) {
                throw new TrueTypeException(iOException.getMessage());
            }
        }
        return this.postScriptInformation;
    }

    public String getPsName() {
        return this.psName;
    }

    public TTTable getTable(byte[] byArray) {
        int n = 0;
        while (n < this.getTables().length) {
            TTTable tTTable = this.tables[n];
            if (Arrays.equals(tTTable.getName(), byArray)) {
                return tTTable;
            }
            ++n;
        }
        return null;
    }

    public TTTable[] getTables() {
        return this.tables;
    }

    protected void initializeFromLocator() throws IOException {
        IRandomAccess iRandomAccess = null;
        try {
            iRandomAccess = this.getLocator().getRandomAccess();
            TTFontParser tTFontParser = new TTFontParser();
            tTFontParser.parseTables(this);
            try {
                this.setFontName(this);
            }
            catch (TrueTypeException trueTypeException) {
                throw new IOException(trueTypeException.getMessage());
            }
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    protected void setFontFamilyName(String string) {
        this.fontFamilyName = string;
    }

    protected void setFontName(TTFont tTFont) throws TrueTypeException {
        TTNaming tTNaming = tTFont.getNaming();
        if (tTNaming != null) {
            tTFont.setFontFamilyName(tTNaming.getValue(1));
            String string = tTNaming.getValue(2);
            tTFont.setFontStyle(FontStyle.getFontStyle(string));
            tTFont.setPsName(tTNaming.getValue(6));
            if (tTFont.getPsName() == null) {
                tTFont.setPsName(String.valueOf(tTFont.getFontFamilyName()) + "-" + tTFont.getFontStyle().getId());
            }
        }
    }

    protected void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected void setLocator(ILocator iLocator) {
        this.locator = iLocator;
    }

    public void setPsName(String string) {
        this.psName = string;
    }

    protected void setTables(TTTable[] tTTableArray) {
        this.tables = tTTableArray;
    }
}

