/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.hybrid.image.CwtHybridImage;
import de.intarsys.cwt.hybrid.image.ImageIOImageEntry;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageEntry;
import de.intarsys.cwt.image.ImageContainer;
import de.intarsys.cwt.image.ImageMetadata;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageIOImageContainer
extends ImageContainer {
    private ILocator locator;
    private ImageReader imageReader;
    private ImageInputStream imageStream;
    private ImageReaderSpi provider;
    private int count;
    private ImageMetadata metadata;
    private List imageEntries = new ArrayList();
    private InputStream inputStream;

    public static ImageIOImageContainer createFromLocator(ILocator iLocator) throws IOException {
        ImageReaderSpi imageReaderSpi = ImageIOImageContainer.lookupProviderBySuffix(iLocator.getType());
        if (imageReaderSpi == null) {
            throw new IllegalArgumentException("unknown suffix");
        }
        return ImageIOImageContainer.createFromLocator(iLocator, imageReaderSpi);
    }

    public static ImageIOImageContainer createFromLocator(ILocator iLocator, ImageReaderSpi imageReaderSpi) throws IOException {
        ImageIOImageContainer imageIOImageContainer = new ImageIOImageContainer(iLocator, imageReaderSpi);
        imageIOImageContainer.open();
        return imageIOImageContainer;
    }

    public static ImageIOImageContainer createFromLocator(ILocator iLocator, String string) throws IOException {
        ImageReaderSpi imageReaderSpi = ImageIOImageContainer.lookupProviderByFormatName(string);
        if (imageReaderSpi == null) {
            throw new IllegalArgumentException("unknown format name");
        }
        return ImageIOImageContainer.createFromLocator(iLocator, imageReaderSpi);
    }

    protected static ImageReaderSpi lookupProviderByFormatName(String string) {
        if (string == null) {
            return null;
        }
        Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            String[] stringArray = imageReaderSpi.getFormatNames();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string.equalsIgnoreCase(string2)) {
                    return imageReaderSpi;
                }
                ++n;
            }
        }
        return null;
    }

    protected static ImageReaderSpi lookupProviderBySuffix(String string) {
        if (string == null) {
            return null;
        }
        Iterator<ImageReaderSpi> iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = iterator.next();
            String[] stringArray = imageReaderSpi.getFileSuffixes();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string.equalsIgnoreCase(string2)) {
                    return imageReaderSpi;
                }
                ++n;
            }
        }
        return null;
    }

    protected ImageIOImageContainer(ILocator iLocator, ImageReaderSpi imageReaderSpi) {
        this.locator = iLocator;
        this.provider = imageReaderSpi;
    }

    protected void basicClose() throws IOException {
        if (this.imageReader != null) {
            this.imageReader.dispose();
            this.imageReader = null;
        }
        if (this.imageStream != null) {
            this.imageStream.close();
            this.imageStream = null;
        }
        StreamTools.close((InputStream)this.inputStream);
    }

    public IImageEntry getImageAt(int n) {
        if (n >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        return (IImageEntry)this.imageEntries.get(n);
    }

    public int getImageCount() {
        return this.count;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public synchronized ImageMetadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = ImageMetadata.createFromImageReader(this.imageReader);
        }
        return this.metadata;
    }

    protected IImage loadImage(int n) throws IOException {
        BufferedImage bufferedImage;
        if (n >= this.getImageCount()) {
            throw new IllegalArgumentException("invalid index");
        }
        if ((bufferedImage = this.imageReader.read(n++)) == null) {
            return null;
        }
        return new CwtHybridImage(bufferedImage);
    }

    protected void open() throws IOException {
        try {
            this.inputStream = this.getLocator().getInputStream();
            this.imageStream = ImageIO.createImageInputStream(this.inputStream);
            this.imageReader = this.provider.createReaderInstance();
            this.imageReader.setInput(this.imageStream);
            this.count = this.imageReader.getNumImages(true);
            int n = 0;
            while (n < this.count) {
                this.imageEntries.add(new ImageIOImageEntry(this, n));
                ++n;
            }
        }
        catch (IOException iOException) {
            this.basicClose();
            throw iOException;
        }
        catch (Exception exception) {
            this.basicClose();
            throw new IOException("unexpected exception opening file");
        }
    }
}

