/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.image.ISwtImage;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;

public class CwtSwtImage
implements ISwtImage {
    public static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private int height;
    private Image swtImage;
    private ImageData swtImageData;
    private int width;

    public CwtSwtImage(ImageData imageData) {
        this.swtImageData = imageData;
        this.setWidth(imageData.width);
        this.setHeight(imageData.height);
    }

    protected Image createSwtImage(Device device) {
        return new Image(device, this.getImageData());
    }

    public void drawFromGraphicsContext(IGraphicsContext iGraphicsContext, float f, float f2) {
        Image image;
        Object[] objectArray;
        GC gC = ((CwtSwtGraphicsContext)iGraphicsContext).getGc();
        ImageData imageData = this.getImageData();
        Transform transform = null;
        if (imageData.data.length > 0xFFFFFF) {
            transform = new Transform(gC.getDevice());
            gC.getTransform(transform);
            objectArray = new float[6];
            transform.getElements((float[])objectArray);
            double d = objectArray[0];
            double d2 = objectArray[3];
            double d3 = objectArray[1];
            double d4 = objectArray[2];
            double d5 = Math.pow(d * d + d4 * d4, 0.5);
            double d6 = Math.pow(d2 * d2 + d3 * d3, 0.5);
            imageData = imageData.scaledTo((int)Math.round((double)imageData.width * d5), (int)Math.round((double)imageData.height * d6));
            image = new Transform(gC.getDevice(), (float[])objectArray);
            image.scale((float)(1.0 / d5), (float)(1.0 / d6));
            gC.setTransform((Transform)image);
            image.dispose();
        }
        try {
            objectArray = null;
            if (IS_GTK && gC.getDevice() instanceof Printer && imageData.transparentPixel == -1 && imageData.alphaData == null && imageData.maskData == null) {
                objectArray = new byte[imageData.width * imageData.height];
                Arrays.fill(objectArray, (byte)-1);
                imageData.alphaData = objectArray;
            }
            try {
                image = new Image(gC.getDevice(), imageData);
                try {
                    gC.drawImage(image, (int)f, (int)f2);
                }
                finally {
                    image.dispose();
                }
            }
            finally {
                if (objectArray != null) {
                    imageData.alphaData = null;
                }
            }
        }
        finally {
            if (transform != null) {
                gC.setTransform(transform);
                transform.dispose();
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage(Device device) {
        if (this.swtImage == null) {
            this.swtImage = this.createSwtImage(device);
        }
        return this.swtImage;
    }

    public ImageData getImageData() {
        return this.swtImageData;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int n) {
        this.height = n;
    }

    protected void setWidth(int n) {
        this.width = n;
    }
}

