/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.cwt.swt.image.SwtCompatibleRaster;
import de.intarsys.tools.system.SystemTools;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectValueHolder;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.BytePackedRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageConverterAwt2Swt {
    private static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> ConvertOps = new HashMap<ColorSpace, Map<ColorSpace, ColorConvertOp>>();
    private static OS_Switch OsSwitch = SystemTools.isWindows() ? new OS_Windows() : new OS_Other();
    private BufferedImage bufferedImage;
    private ImageData imageData;

    public static BufferedImage createSwtCompatibleAwtImage(int n, int n2, boolean bl) {
        ComponentColorModel componentColorModel = bl ? CwtAwtImageTools.getRgbTransparentColorModel() : CwtAwtImageTools.getRgbColorModel();
        int n3 = componentColorModel.getNumComponents();
        int[] nArray = new int[n3];
        OsSwitch.initializeRgbBandOffsets(nArray);
        if (nArray.length > 3) {
            nArray[3] = 3;
        }
        PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n, n2, n3, n * n3, nArray);
        DataBufferByte dataBufferByte = new DataBufferByte(n * n2 * n3);
        SwtCompatibleRaster swtCompatibleRaster = new SwtCompatibleRaster(pixelInterleavedSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, swtCompatibleRaster, false, null);
    }

    protected static Map<ColorSpace, Map<ColorSpace, ColorConvertOp>> getConvertOps() {
        return ConvertOps;
    }

    public ImageConverterAwt2Swt(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    protected void computeValuesFromAwtImage(int n, IValueHolder iValueHolder, IValueHolder iValueHolder2, IValueHolder iValueHolder3) {
        SampleModel sampleModel = this.getBufferedImage().getSampleModel();
        if (sampleModel.getDataType() != 0) {
            throw new IllegalStateException();
        }
        ColorModel colorModel = this.getBufferedImage().getColorModel();
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            throw new IllegalStateException();
        }
        if (colorModel instanceof ComponentColorModel) {
            if (!(sampleModel instanceof ComponentSampleModel)) {
                throw new IllegalStateException();
            }
            this.computeValuesPaletteDirect((ComponentSampleModel)sampleModel, (ComponentColorModel)colorModel, iValueHolder, iValueHolder2, iValueHolder3);
            return;
        }
        if (colorModel instanceof IndexColorModel) {
            this.computeValuesPaletteIndexed((IndexColorModel)colorModel, n, iValueHolder, iValueHolder2, iValueHolder3);
            return;
        }
        throw new IllegalStateException();
    }

    protected void computeValuesPaletteDirect(ComponentSampleModel componentSampleModel, ComponentColorModel componentColorModel, IValueHolder iValueHolder, IValueHolder iValueHolder2, IValueHolder iValueHolder3) {
        int[] nArray = componentColorModel.getComponentSize();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != 8) {
                throw new IllegalStateException();
            }
            ++n;
        }
        int[] nArray2 = componentSampleModel.getBandOffsets();
        if (nArray2.length == 4 && nArray2[3] != 3) {
            throw new IllegalStateException();
        }
        PaletteData paletteData = new PaletteData(0xFF0000 >> (nArray2[0] << 3), 0xFF0000 >> (nArray2[1] << 3), 0xFF0000 >> (nArray2[2] << 3));
        iValueHolder.set((Object)paletteData);
        iValueHolder2.set((Object)3);
    }

    protected void computeValuesPaletteIndexed(IndexColorModel indexColorModel, int n, IValueHolder iValueHolder, IValueHolder iValueHolder2, IValueHolder iValueHolder3) {
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        RGB[] rGBArray = new RGB[(int)Math.pow(2.0, n)];
        int n2 = 0;
        while (n2 < nArray.length) {
            RGB rGB;
            rGBArray[n2] = rGB = new RGB(nArray[n2] >> 16 & 0xFF, nArray[n2] >> 8 & 0xFF, nArray[n2] & 0xFF);
            ++n2;
        }
        n2 = nArray.length;
        while (n2 < rGBArray.length) {
            rGBArray[n2] = new RGB(0, 0, 0);
            ++n2;
        }
        iValueHolder.set((Object)new PaletteData(rGBArray));
        iValueHolder2.set((Object)1);
        iValueHolder3.set((Object)indexColorModel.getTransparentPixel());
    }

    protected void convert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        ColorConvertOp colorConvertOp;
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        Map<ColorSpace, ColorConvertOp> map = ImageConverterAwt2Swt.getConvertOps().get(colorSpace);
        if (map == null) {
            map = new HashMap<ColorSpace, ColorConvertOp>();
            ImageConverterAwt2Swt.getConvertOps().put(colorSpace, map);
            colorConvertOp = null;
        } else {
            colorConvertOp = map.get(colorSpace2);
        }
        if (colorConvertOp == null) {
            colorConvertOp = new ColorConvertOp(null);
            map.put(colorSpace2, colorConvertOp);
        }
        colorConvertOp.filter(bufferedImage, bufferedImage2);
    }

    protected ImageData createImageData() {
        byte[] byArray;
        byte[] byArray2;
        WritableRaster writableRaster;
        ColorModel colorModel = this.getBufferedImage().getColorModel();
        int n = colorModel.getPixelSize();
        if (colorModel.getTransparency() == 3) {
            n = n / colorModel.getNumComponents() * colorModel.getNumColorComponents();
        }
        ObjectValueHolder objectValueHolder = new ObjectValueHolder(null);
        ObjectValueHolder objectValueHolder2 = new ObjectValueHolder((Object)0);
        ObjectValueHolder objectValueHolder3 = new ObjectValueHolder((Object)-1);
        try {
            this.computeValuesFromAwtImage(n, (IValueHolder)objectValueHolder, (IValueHolder)objectValueHolder2, (IValueHolder)objectValueHolder3);
            writableRaster = this.getBufferedImage().getRaster();
        }
        catch (IllegalStateException illegalStateException) {
            BufferedImage bufferedImage = ImageConverterAwt2Swt.createSwtCompatibleAwtImage(this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight(), colorModel.hasAlpha());
            this.convert(this.getBufferedImage(), bufferedImage);
            n = 24;
            objectValueHolder.set((Object)OsSwitch.createRgbPaletteData());
            objectValueHolder2.set((Object)3);
            writableRaster = bufferedImage.getRaster();
        }
        byte[] byArray3 = writableRaster instanceof SwtCompatibleRaster ? ((SwtCompatibleRaster)writableRaster).getDataStorage() : (writableRaster instanceof ByteInterleavedRaster ? ((ByteInterleavedRaster)writableRaster).getDataStorage() : (writableRaster instanceof BytePackedRaster ? ((BytePackedRaster)writableRaster).getDataStorage() : (byte[])writableRaster.getDataElements(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), null)));
        if (((PaletteData)objectValueHolder.get()).isDirect && colorModel.hasAlpha()) {
            byArray2 = new byte[byArray3.length / 4];
            byArray = new byte[byArray3.length / 4 * 3];
            int n2 = 0;
            while (n2 < byArray2.length) {
                byArray[n2 * 3] = byArray3[n2 * 4];
                byArray[n2 * 3 + 1] = byArray3[n2 * 4 + 1];
                byArray[n2 * 3 + 2] = byArray3[n2 * 4 + 2];
                byArray2[n2] = byArray3[n2 * 4 + 3];
                ++n2;
            }
        } else {
            byArray2 = null;
            byArray = byArray3;
        }
        this.imageData = new ImageData(this.getBufferedImage().getWidth(), this.getBufferedImage().getHeight(), n, (PaletteData)objectValueHolder.get(), ((Integer)objectValueHolder2.get()).intValue(), byArray);
        this.imageData.transparentPixel = (Integer)objectValueHolder3.get();
        if (byArray2 != null) {
            this.imageData.alphaData = byArray2;
        }
        return this.imageData;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public ImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = this.createImageData();
        }
        return this.imageData;
    }

    static class OS_Other
    implements OS_Switch {
        OS_Other() {
        }

        public PaletteData createRgbPaletteData() {
            return new PaletteData(0xFF0000, 65280, 255);
        }

        public void initializeRgbBandOffsets(int[] nArray) {
            int n = 0;
            while (n < 3) {
                nArray[n] = n;
                ++n;
            }
        }
    }

    static interface OS_Switch {
        public PaletteData createRgbPaletteData();

        public void initializeRgbBandOffsets(int[] var1);
    }

    static class OS_Windows
    implements OS_Switch {
        OS_Windows() {
        }

        public PaletteData createRgbPaletteData() {
            return new PaletteData(255, 65280, 0xFF0000);
        }

        public void initializeRgbBandOffsets(int[] nArray) {
            int n = 0;
            while (n < 3) {
                nArray[n] = 2 - n;
                ++n;
            }
        }
    }
}

