/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexMacroDefinition;
import bibtex.dom.BibtexMacroReference;
import bibtex.dom.BibtexPreamble;
import bibtex.dom.BibtexStandardMacros;
import bibtex.dom.BibtexString;
import bibtex.dom.BibtexToplevelComment;
import bibtex.expansions.AbstractExpander;
import bibtex.expansions.Expander;
import bibtex.expansions.ExpansionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class MacroReferenceExpander
extends AbstractExpander
implements Expander {
    private final boolean expandStandardMacros;
    private final boolean expandMonthAbbreviations;
    private final boolean removeMacros;

    public MacroReferenceExpander(boolean expandStandardMacros, boolean expandMonthAbbreviations, boolean removeMacros) {
        this(expandStandardMacros, expandMonthAbbreviations, removeMacros, true);
    }

    public MacroReferenceExpander(boolean expandStandardMacros, boolean expandMonthAbbreviations, boolean removeMacros, boolean throwAllExpansionExceptions) {
        super(throwAllExpansionExceptions);
        this.expandMonthAbbreviations = expandMonthAbbreviations;
        this.expandStandardMacros = expandStandardMacros;
        this.removeMacros = removeMacros;
    }

    public void expand(BibtexFile bibtexFile) throws ExpansionException {
        HashMap<String, BibtexAbstractValue> stringKey2StringValue = new HashMap<String, BibtexAbstractValue>();
        Iterator entryIt = bibtexFile.getEntries().iterator();
        while (entryIt.hasNext()) {
            BibtexAbstractEntry abstractEntry = (BibtexAbstractEntry)entryIt.next();
            if (abstractEntry instanceof BibtexMacroDefinition) {
                BibtexMacroDefinition bibtexStringDefinition = (BibtexMacroDefinition)abstractEntry;
                BibtexAbstractValue simplifiedValue = this.simplify(bibtexFile, bibtexStringDefinition.getValue(), stringKey2StringValue);
                bibtexStringDefinition.setValue(simplifiedValue);
                if (this.removeMacros) {
                    bibtexFile.removeEntry(bibtexStringDefinition);
                }
                stringKey2StringValue.put(bibtexStringDefinition.getKey().toLowerCase(), simplifiedValue);
                continue;
            }
            if (abstractEntry instanceof BibtexPreamble) {
                BibtexPreamble preamble = (BibtexPreamble)abstractEntry;
                preamble.setContent(this.simplify(bibtexFile, preamble.getContent(), stringKey2StringValue));
                continue;
            }
            if (abstractEntry instanceof BibtexEntry) {
                BibtexEntry entry = (BibtexEntry)abstractEntry;
                Iterator fieldIt = entry.getFields().entrySet().iterator();
                while (fieldIt.hasNext()) {
                    Map.Entry field = fieldIt.next();
                    if (field.getValue() instanceof BibtexString) continue;
                    entry.setField((String)field.getKey(), this.simplify(bibtexFile, (BibtexAbstractValue)field.getValue(), stringKey2StringValue));
                }
                continue;
            }
            if (abstractEntry instanceof BibtexToplevelComment) continue;
            this.throwExpansionException("MacroReferenceExpander.expand(): I don't support \"" + abstractEntry.getClass().getName() + "\". Use the force, read the source!");
        }
        this.finishExpansion();
    }

    private BibtexAbstractValue simplify(BibtexFile factory, BibtexAbstractValue compositeValue, HashMap stringKey2StringValue) throws ExpansionException {
        if (compositeValue instanceof BibtexString) {
            return (BibtexString)compositeValue;
        }
        if (compositeValue instanceof BibtexMacroReference) {
            BibtexMacroReference reference = (BibtexMacroReference)compositeValue;
            String key = reference.getKey();
            BibtexString simplifiedValue = (BibtexString)stringKey2StringValue.get(key);
            if (simplifiedValue == null) {
                if (!this.expandMonthAbbreviations && BibtexStandardMacros.isMonthAbbreviation(key)) {
                    return reference;
                }
                if (!this.expandStandardMacros && BibtexStandardMacros.isStandardMacro(key)) {
                    return reference;
                }
                if (BibtexStandardMacros.isStandardMacro(key)) {
                    return factory.makeString(BibtexStandardMacros.resolveStandardMacro(key));
                }
                this.throwExpansionException("Invalid macro reference (target does not exist): \"" + reference.getKey() + "\"");
                return factory.makeString("");
            }
            return simplifiedValue;
        }
        if (compositeValue instanceof BibtexConcatenatedValue) {
            BibtexConcatenatedValue concatenatedValue = (BibtexConcatenatedValue)compositeValue;
            BibtexAbstractValue left = this.simplify(factory, concatenatedValue.getLeft(), stringKey2StringValue);
            BibtexAbstractValue right = this.simplify(factory, concatenatedValue.getRight(), stringKey2StringValue);
            if (left instanceof BibtexString && right instanceof BibtexString) {
                return factory.makeString(String.valueOf(((BibtexString)left).getContent()) + ((BibtexString)right).getContent());
            }
            return factory.makeConcatenatedValue(left, right);
        }
        this.throwExpansionException("MacroReferenceExpander.simplify(): I don't support \"" + compositeValue.getClass().getName() + "\". Use the force, read the source!");
        return factory.makeString("");
    }
}

