/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartitionedMap
implements Map {
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private Map child;
    private Map parent;

    public static Map create(Map map, Map map2) {
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        return new PartitionedMap(map, map2);
    }

    public PartitionedMap() {
        this(null, null);
    }

    public PartitionedMap(Map map, Map map2) {
        this.setChild(map2 == null ? new HashMap() : map2);
        this.setParent(map == null ? new HashMap() : map);
    }

    public void clear() {
        this.getChild().clear();
    }

    public boolean containsKey(Object object) {
        return this.getChild().containsKey(object) || this.getParent() != null && this.getParent().containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.getChild().containsValue(object) || this.getParent() != null && this.getParent().containsValue(object);
    }

    public Set entrySet() {
        AbstractSet abstractSet = new AbstractSet(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object object) {
                return PartitionedMap.this.getChild().entrySet().contains(object) || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().entrySet().contains(object);
            }

            public Iterator iterator() {
                return new PartitionIterator(2);
            }

            public boolean remove(Object object) {
                return PartitionedMap.this.getChild().entrySet().remove(object) || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().entrySet().remove(object);
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return abstractSet;
    }

    public Object get(Object object) {
        Object v = this.getChild().get(object);
        return v == null ? (this.getParent() == null ? null : this.getParent().get(object)) : v;
    }

    protected Map getChild() {
        return this.child;
    }

    public Map getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return this.getChild().isEmpty() && (this.getParent() == null || this.getParent().isEmpty());
    }

    public Set keySet() {
        AbstractSet abstractSet = new AbstractSet(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object object) {
                return PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().containsKey(object) || PartitionedMap.this.getChild().containsKey(object);
            }

            public Iterator iterator() {
                return new PartitionIterator(0);
            }

            public boolean remove(Object object) {
                return PartitionedMap.this.getChild().remove(object) != null || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().remove(object) != null;
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return abstractSet;
    }

    public Object put(Object object, Object object2) {
        return this.getChild().put(object, object2);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        if (this.getParent() != null && this.getParent().containsKey(object)) {
            return this.getParent().remove(object);
        }
        return this.getChild().remove(object);
    }

    private void setChild(Map map) {
        this.child = map;
    }

    public void setParent(Map map) {
        this.parent = map;
    }

    public int size() {
        return (this.getParent() == null ? 0 : this.getParent().size()) + this.getChild().size();
    }

    public String toString() {
        return String.valueOf(this.getParent() == null ? "" : String.valueOf(this.getParent().toString()) + System.getProperty("line.separator")) + this.getChild().toString();
    }

    public Collection values() {
        AbstractCollection abstractCollection = new AbstractCollection(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object object) {
                return PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().containsValue(object) || PartitionedMap.this.getChild().containsValue(object);
            }

            public Iterator iterator() {
                return new PartitionIterator(1);
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return abstractCollection;
    }

    private class PartitionIterator
    implements Iterator {
        Iterator parentIterator;
        Iterator subIterator;
        int type;

        PartitionIterator(int n) {
            this.parentIterator = PartitionedMap.this.getParent().entrySet().iterator();
            this.subIterator = PartitionedMap.this.getChild().entrySet().iterator();
            this.type = n;
        }

        public boolean hasNext() {
            return this.parentIterator.hasNext() || this.subIterator.hasNext();
        }

        public Object next() {
            Map.Entry entry = null;
            entry = this.parentIterator.hasNext() ? (Map.Entry)this.parentIterator.next() : (Map.Entry)this.subIterator.next();
            if (entry != null) {
                return this.type == 0 ? entry.getKey() : (this.type == 1 ? entry.getValue() : entry);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Partitioned Maps do not support this");
        }
    }
}

