/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.exception.KnownReason;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTools {
    public static IOException createIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        iOException.initCause(throwable);
        return iOException;
    }

    public static void fail() {
        throw new RuntimeException("failed");
    }

    public static <T> T futureSimpleGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof Error) {
                throw (Error)executionException.getCause();
            }
            if (executionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new InternalError("Program execution should not reach this point.");
        }
    }

    public static <T extends Number> T futureSimpleGetNumber(Future<T> future) {
        Number number = (Number)ExceptionTools.futureSimpleGet(future);
        if (number == null) {
            number = new Integer(-1);
        }
        return (T)number;
    }

    public static Throwable getInChain(Throwable throwable, Class<?> clazz) {
        if (clazz.isInstance(throwable)) {
            return throwable;
        }
        if (throwable.getCause() != null) {
            return ExceptionTools.getInChain(throwable.getCause(), clazz);
        }
        return null;
    }

    public static Throwable getRoot(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        return throwable2;
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static boolean isInChain(Throwable throwable, Class<?> clazz) {
        if (clazz.isInstance(throwable)) {
            return true;
        }
        if (throwable.getCause() != null) {
            return ExceptionTools.isInChain(throwable.getCause(), clazz);
        }
        return false;
    }

    public static boolean isKnownReason(Throwable throwable) {
        if (throwable instanceof KnownReason) {
            return true;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            return ExceptionTools.isKnownReason(throwable2);
        }
        return false;
    }
}

