/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.EmptyDeclarationBlock;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IFunctorCall;

public class DeclarationBlock
extends Declaration
implements IDeclarationBlock {
    public static final IDeclarationBlock EMPTY = new EmptyDeclarationBlock();
    private IDeclaration[] declarations;

    public DeclarationBlock(Object object) {
        super(object);
        this.declarations = new IDeclaration[0];
    }

    public DeclarationBlock(Object object, IDeclaration[] iDeclarationArray) {
        super(object);
        this.declarations = iDeclarationArray;
    }

    public IFunctorCall accept(IFunctorCall iFunctorCall) throws DeclarationException {
        IFunctorCall iFunctorCall2 = iFunctorCall;
        int n = 0;
        while (n < this.declarations.length) {
            IDeclaration iDeclaration = this.declarations[n];
            iFunctorCall2 = iDeclaration.accept(iFunctorCall2);
            ++n;
        }
        return iFunctorCall2;
    }

    public void addDeclaration(IDeclaration iDeclaration) {
        IDeclaration[] iDeclarationArray = new IDeclaration[this.declarations.length + 1];
        System.arraycopy(this.declarations, 0, iDeclarationArray, 0, this.declarations.length);
        iDeclarationArray[this.declarations.length] = iDeclaration;
        this.declarations = iDeclarationArray;
    }

    public IDeclaration[] getDeclarations() {
        return this.declarations;
    }

    public boolean isBlock() {
        return true;
    }

    public boolean removeDeclaration(IDeclaration iDeclaration) {
        int n = 0;
        while (n < this.declarations.length) {
            if (this.declarations[n] == iDeclaration) {
                IDeclaration[] iDeclarationArray = new IDeclaration[this.declarations.length - 1];
                System.arraycopy(this.declarations, 0, iDeclarationArray, 0, n);
                System.arraycopy(this.declarations, n + 1, iDeclarationArray, n, this.declarations.length - n - 1);
                this.declarations = iDeclarationArray;
                return true;
            }
            ++n;
        }
        return false;
    }

    public int size() {
        return this.declarations.length;
    }
}

