/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclaration;
import de.intarsys.tools.functor.ChainedArgs;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import java.util.Set;

public class DeclaredArgs
implements IArgs {
    private IArgs argsIn;
    private IArgs argsOut;
    private Args declaredArgs;
    private boolean lazy = true;
    private boolean strict = false;

    public static DeclaredArgs createStrict(IArgs iArgs) {
        DeclaredArgs declaredArgs = new DeclaredArgs(iArgs);
        declaredArgs.setLazy(false);
        declaredArgs.setStrict(true);
        return declaredArgs;
    }

    public static DeclaredArgs createStrictIfDeclared(IArgs iArgs) {
        DeclaredArgs declaredArgs = new DeclaredArgs(iArgs);
        declaredArgs.setLazy(true);
        declaredArgs.setStrict(true);
        return declaredArgs;
    }

    public static DeclaredArgs createTransparent(IArgs iArgs) {
        DeclaredArgs declaredArgs = new DeclaredArgs(iArgs);
        declaredArgs.setLazy(false);
        declaredArgs.setStrict(false);
        return declaredArgs;
    }

    protected DeclaredArgs(IArgs iArgs) {
        this.argsIn = iArgs;
        this.argsOut = iArgs;
    }

    public void add(Object object) {
        this.switchArgs();
        this.declaredArgs.add(object);
    }

    public void clear() {
        this.switchArgs();
        this.declaredArgs.clear();
    }

    protected void declare(IFunctorCall iFunctorCall, ArgumentDeclaration argumentDeclaration) throws DeclarationException {
        this.declare(iFunctorCall, argumentDeclaration.getName(), argumentDeclaration.getIndex(), argumentDeclaration.getDefaultFunctor());
    }

    protected void declare(IFunctorCall iFunctorCall, String string, int n, IFunctor iFunctor) throws DeclarationException {
        this.switchArgs();
        Object object = null;
        if (this.argsIn.isNamed() ? (object = this.argsIn.get(string)) == null && this.argsIn.isDefined(string) : this.argsIn.isIndexed() && (object = this.argsIn.get(n)) == null && this.argsIn.isDefined(n)) {
            return;
        }
        if (object instanceof IArgs || object == null) {
            Object object2 = null;
            if (iFunctor != null) {
                try {
                    object2 = iFunctor.perform(iFunctorCall);
                }
                catch (FunctorInvocationException functorInvocationException) {
                    throw new DeclarationException(functorInvocationException);
                }
            }
            if (object2 instanceof IDeclaration[]) {
                if (object == null) {
                    object = Args.create();
                }
                DeclaredArgs declaredArgs = new DeclaredArgs((IArgs)object);
                declaredArgs.setLazy(this.isLazy());
                declaredArgs.setStrict(this.isStrict());
                IDeclaration[] iDeclarationArray = (IDeclaration[])object2;
                int n2 = 0;
                while (n2 < iDeclarationArray.length) {
                    IDeclaration iDeclaration = iDeclarationArray[n2];
                    if (!(iDeclaration instanceof ArgumentDeclaration)) {
                        throw new DeclarationException("ArgumentDeclaration expected");
                    }
                    ArgumentDeclaration argumentDeclaration = (ArgumentDeclaration)iDeclaration;
                    declaredArgs.declare(iFunctorCall, argumentDeclaration);
                    ++n2;
                }
                object = declaredArgs;
            } else if (object == null) {
                object = object2;
            }
        }
        this.declaredArgs.put(n, object);
        this.declaredArgs.put(string, object);
    }

    public Object get(int n) {
        return this.argsOut.get(n);
    }

    public Object get(int n, Object object) {
        return this.argsOut.get(n, object);
    }

    public Object get(String string) {
        return this.argsOut.get(string);
    }

    public Object get(String string, Object object) {
        return this.argsOut.get(string, object);
    }

    public IArgs getArgsIn() {
        return this.argsIn;
    }

    public boolean isDefined(int n) {
        return this.argsOut.isDefined(n);
    }

    public boolean isDefined(String string) {
        return this.argsOut.isDefined(string);
    }

    public boolean isIndexed() {
        return true;
    }

    protected boolean isLazy() {
        return this.lazy;
    }

    public boolean isNamed() {
        return true;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    public Set names() {
        return this.argsOut.names();
    }

    public void put(int n, Object object) {
        this.switchArgs();
        this.declaredArgs.put(n, object);
    }

    public void put(String string, Object object) {
        this.switchArgs();
        this.declaredArgs.put(string, object);
    }

    protected void setLazy(boolean bl) {
        this.lazy = bl;
    }

    protected void setStrict(boolean bl) {
        this.strict = bl;
        if (bl && !this.lazy) {
            this.switchArgs();
        }
    }

    public int size() {
        return this.argsOut.size();
    }

    protected void switchArgs() {
        if (this.argsIn != this.argsOut) {
            return;
        }
        this.declaredArgs = new Args();
        this.argsOut = this.strict ? this.declaredArgs : new ChainedArgs(this.declaredArgs, this.argsIn);
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }
}

