/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class GeometryTools {
    public static Point2D deltaTransformPoint(AffineTransform affineTransform, float f, float f2) {
        Point2D.Float float_ = new Point2D.Float(f, f2);
        affineTransform.deltaTransform(float_, float_);
        return float_;
    }

    public static void deltaTransformPoint(AffineTransform affineTransform, float[] fArray) {
        double[] dArray = new double[]{fArray[0], fArray[1]};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        fArray[0] = (float)dArray[0];
        fArray[1] = (float)dArray[1];
    }

    public static void deltaTransformPoint(AffineTransform affineTransform, Point2D point2D) {
        affineTransform.deltaTransform(point2D, point2D);
    }

    public static double getScale(AffineTransform affineTransform) {
        return Math.abs(affineTransform.getScaleX() + affineTransform.getShearX());
    }

    public static void inverseTransformRect(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        double[] dArray = new double[4];
        dArray[0] = rectangle2D.getX();
        dArray[2] = rectangle2D.getMaxX();
        dArray[1] = rectangle2D.getY();
        dArray[3] = rectangle2D.getMaxY();
        try {
            affineTransform.inverseTransform(dArray, 0, dArray, 0, dArray.length >> 1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        rectangle2D.setRect(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        GeometryTools.normalizeRect(rectangle2D);
    }

    public static void normalizeRect(float[] fArray) {
        float f;
        if (fArray[0] > fArray[2]) {
            f = fArray[0];
            fArray[0] = fArray[2];
            fArray[2] = f;
        }
        if (fArray[1] > fArray[3]) {
            f = fArray[1];
            fArray[1] = fArray[3];
            fArray[3] = f;
        }
    }

    public static void normalizeRect(Rectangle2D rectangle2D) {
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (d3 < 0.0) {
            d += d3;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        rectangle2D.setRect(d, d2, d3, d4);
    }

    public static float[] toFloatArray(Rectangle2D rectangle2D) {
        float[] fArray;
        fArray = new float[]{(float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)((double)fArray[0] + rectangle2D.getWidth()), (float)((double)fArray[1] + rectangle2D.getHeight())};
        return fArray;
    }

    public static Point2D transformPoint(AffineTransform affineTransform, float f, float f2) {
        Point2D.Float float_ = new Point2D.Float(f, f2);
        affineTransform.transform(float_, float_);
        return float_;
    }

    public static void transformPoint(AffineTransform affineTransform, float[] fArray) {
        affineTransform.transform(fArray, 0, fArray, 0, 1);
    }

    public static void transformPoint(AffineTransform affineTransform, Point2D point2D) {
        affineTransform.transform(point2D, point2D);
    }

    public static void transformRect(AffineTransform affineTransform, float[] fArray) {
        affineTransform.transform(fArray, 0, fArray, 0, 2);
        GeometryTools.normalizeRect(fArray);
    }

    public static void transformRect(AffineTransform affineTransform, Rectangle2D rectangle2D) {
        double[] dArray = new double[4];
        dArray[0] = rectangle2D.getMinX();
        dArray[2] = rectangle2D.getMaxX();
        dArray[1] = rectangle2D.getMinY();
        dArray[3] = rectangle2D.getMaxY();
        affineTransform.transform(dArray, 0, dArray, 0, dArray.length >> 1);
        rectangle2D.setRect(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        GeometryTools.normalizeRect(rectangle2D);
    }

    private GeometryTools() {
    }
}

