/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Install {
    private static String platformId;
    private static String platformFallbackId;
    private static String platformDefaultId;
    private boolean platformDependent = false;
    protected final String name;
    protected final String path;
    protected File[] files;
    protected ClassLoader classLoader;

    protected static void copy(URL uRL, File file) throws IOException, FileNotFoundException {
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                StreamTools.copyStream(inputStream, fileOutputStream);
            }
            catch (IOException iOException) {
                throw ExceptionTools.createIOException("resource '" + uRL.getFile() + "' load error", iOException);
            }
        }
        finally {
            StreamTools.close(inputStream);
            StreamTools.close(fileOutputStream);
        }
    }

    protected static String createPlatformFallbackId() {
        String[] stringArray = SystemTools.getOSName().split("\\s");
        return (String.valueOf(stringArray[0]) + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static String createPlatformId() {
        return (String.valueOf(SystemTools.getOSName()) + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static void deleteOnExit(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                Install.deleteOnExit(file2);
                ++n;
            }
        }
        file.deleteOnExit();
    }

    public static String getPlatformDefaultId() {
        if (platformDefaultId == null) {
            return "default";
        }
        return platformDefaultId;
    }

    public static String getPlatformFallbackId() {
        if (platformFallbackId == null) {
            return Install.createPlatformFallbackId();
        }
        return platformFallbackId;
    }

    public static String getPlatformId() {
        if (platformId == null) {
            return Install.createPlatformId();
        }
        return platformId;
    }

    public static void setPlatformFallbackId(String string) {
        platformFallbackId = string;
    }

    public static void setPlatformId(String string) {
        platformId = string;
    }

    public Install(String string, String string2, boolean bl) {
        this.path = string;
        this.name = string2;
        this.platformDependent = bl;
    }

    public boolean delete() {
        if (this.files == null) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        while (n < this.files.length) {
            File file = this.files[n];
            bl = bl && FileTools.deleteRecursivly(file);
            ++n;
        }
        return bl;
    }

    protected Enumeration<URL> find(String string) {
        Enumeration<URL> enumeration = null;
        try {
            if (this.isPlatformDependent()) {
                enumeration = this.open(this.getResourceNameFull(string));
                if (!enumeration.hasMoreElements() && !(enumeration = this.open(this.getResourceNameFallback(string))).hasMoreElements()) {
                    enumeration = this.open(this.getResourceNameDefault(string));
                }
            } else {
                enumeration = this.open(this.getResourceNamePlain(string));
            }
        }
        catch (Exception exception) {}
        return enumeration;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            return classLoader;
        }
        return this.classLoader;
    }

    public File getFile() {
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    public File[] getFiles() {
        return this.files;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    protected String getResourceNameDefault(String string) {
        return String.valueOf(Install.getPlatformDefaultId()) + "/" + string;
    }

    protected String getResourceNameFallback(String string) {
        return String.valueOf(Install.getPlatformFallbackId()) + "/" + string;
    }

    protected String getResourceNameFull(String string) {
        return String.valueOf(Install.getPlatformId()) + "/" + string;
    }

    protected String getResourceNamePlain(String string) {
        return string;
    }

    public boolean isPlatformDependent() {
        return this.platformDependent;
    }

    public File load() throws IOException {
        Enumeration<URL> enumeration = this.find(this.getName());
        if (enumeration != null && enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            File file = this.loadURL(uRL);
            Install.deleteOnExit(file);
            this.files = new File[]{file};
            return file;
        }
        return null;
    }

    public File[] loadAll() throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        Enumeration<URL> enumeration = this.find(this.getName());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                File file = this.loadURL(uRL);
                Install.deleteOnExit(file);
                arrayList.add(file);
            }
        }
        this.files = arrayList.toArray(new File[arrayList.size()]);
        return this.files;
    }

    protected abstract File loadURL(URL var1) throws IOException;

    protected Enumeration<URL> open(String string) throws IOException {
        String string2 = this.prefix(string);
        return this.getClassLoader().getResources(string2);
    }

    protected String prefix(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPath() != null) {
            stringBuilder.append(this.getPath());
            stringBuilder.append("/");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

