/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ByteArrayLocator
extends CommonLocator {
    protected byte[] content;
    protected int length;
    private String fullName;
    private String localName;
    private String type;

    public ByteArrayLocator(byte[] byArray, String string) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.content = byArray;
        this.length = byArray.length;
        this.setFullName(string);
    }

    public ByteArrayLocator(byte[] byArray, String string, String string2) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.content = byArray;
        this.length = byArray.length;
        if (StringTools.isEmpty(string2)) {
            this.setFullName(string);
        } else {
            this.setFullName(String.valueOf(string) + "." + string2);
        }
    }

    public void delete() throws IOException {
    }

    public boolean exists() {
        return this.content != null;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.content, 0, byArray, 0, this.length);
        return byArray;
    }

    public ILocator getChild(String string) {
        return null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getFullName() {
        return this.fullName;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content, 0, this.length);
    }

    public long getLength() {
        return this.length;
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }

            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }
        };
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() {
        return new RandomAccessByteArray(this.content){
            private boolean changed;
            {
                this.changed = false;
            }

            public void flush() throws IOException {
                super.flush();
                if (this.changed) {
                    this.changed = false;
                    ByteArrayLocator.this.content = this.toByteArray();
                    ByteArrayLocator.this.length = ByteArrayLocator.this.content.length;
                }
            }

            public void setLength(long l) {
                this.changed = true;
                super.setLength(l);
            }
        };
    }

    public Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public Reader getReader(String string) throws IOException {
        return new InputStreamReader(this.getInputStream(), string);
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String string) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), string);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) {
        return new ILocator[0];
    }

    public void rename(String string) throws IOException {
        this.setFullName(string);
    }

    protected void setFullName(String string) {
        this.fullName = string;
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string, this.getType());
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }
}

