/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.stream.TempFileOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class FileLocator
extends CommonLocator
implements ILockSupport {
    private File file;
    private String encoding;
    private boolean outOfSynch;
    private boolean synchSynchronous = false;
    private long lastModified = 0L;
    private boolean useTempFile = false;
    private File canonicalFile;

    public FileLocator(File file) {
        this.file = file;
    }

    public FileLocator(String string) {
        this(new File(string));
    }

    public void delete() throws IOException {
        if (this.getFile() == null) {
            return;
        }
        this.getFile().delete();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileLocator)) {
            return false;
        }
        return this.getCanonicalFile().equals(((FileLocator)object).getCanonicalFile());
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public File getCanonicalFile() {
        if (this.canonicalFile == null) {
            try {
                this.canonicalFile = this.getFile().getCanonicalFile();
            }
            catch (IOException iOException) {
                this.canonicalFile = this.getFile();
            }
        }
        return this.canonicalFile;
    }

    public ILocator getChild(String string) {
        File file = new File(this.getFile(), string);
        FileLocator fileLocator = new FileLocator(file);
        fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        return fileLocator;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    public File getFile() {
        return this.file;
    }

    public String getFullName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getAbsolutePath();
    }

    public InputStream getInputStream() throws IOException {
        this.getLastModified();
        return new FileInputStream(this.getFile());
    }

    protected long getLastModified() {
        if (this.lastModified == 0L && this.file.exists()) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public String getLocalName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getFile());
    }

    public ILock getLock() {
        return new FileLocatorLock();
    }

    public OutputStream getOutputStream() throws IOException {
        this.getLastModified();
        if (!this.getFile().getParentFile().exists()) {
            this.getFile().getParentFile().mkdirs();
        }
        if (this.isUseTempFile()) {
            return new TempFileOutputStream(this.getFile(), "tmp_", "." + this.getType());
        }
        return new FileOutputStream(this.getFile());
    }

    public ILocator getParent() {
        File file = FileTools.getParentFile(this.getFile());
        if (file == null) {
            return null;
        }
        FileLocator fileLocator = new FileLocator(file);
        fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        return fileLocator;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        this.getLastModified();
        if (this.isUseTempFile()) {
            throw new UnsupportedOperationException("no random access to temp file");
        }
        return new de.intarsys.tools.randomaccess.RandomAccessFile(this.getFile());
    }

    public Reader getReader() throws IOException {
        this.getLastModified();
        if (this.getEncoding() == null || this.getEncoding().equals("")) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    public Reader getReader(String string) throws IOException {
        this.getLastModified();
        if (string == null || string.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), string);
    }

    public String getType() {
        if (this.getFile() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(this.getFile());
    }

    public String getTypedName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getName();
    }

    public Writer getWriter() throws IOException {
        this.getLastModified();
        if (this.getEncoding() == null || this.getEncoding().equals("")) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getEncoding());
    }

    public Writer getWriter(String string) throws IOException {
        this.getLastModified();
        if (string == null || string.equals("")) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), string);
    }

    public int hashCode() {
        try {
            return this.getFile().getCanonicalFile().hashCode();
        }
        catch (IOException iOException) {
            return 17;
        }
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public synchronized boolean isOutOfSynch() {
        if (this.isSynchSynchronous()) {
            this.synch();
        }
        return this.outOfSynch;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReadOnly() {
        IRandomAccess iRandomAccess;
        block8: {
            block9: {
                if (super.isReadOnly()) {
                    return true;
                }
                iRandomAccess = null;
                try {
                    if (!this.getFile().exists()) {
                        if (!this.getFile().createNewFile()) break block8;
                        this.getFile().delete();
                        break block9;
                    }
                    iRandomAccess = this.getRandomAccess();
                    if (iRandomAccess == null || iRandomAccess.isReadOnly()) break block8;
                }
                catch (IOException iOException) {}
            }
            StreamTools.close(iRandomAccess);
            return false;
        }
        StreamTools.close(iRandomAccess);
        return true;
        catch (Throwable throwable) {
            StreamTools.close(iRandomAccess);
            throw throwable;
        }
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    public ILocator[] listLocators(final ILocatorNameFilter iLocatorNameFilter) throws IOException {
        if (!this.getFile().exists()) {
            throw new FileNotFoundException(String.valueOf(this.getFile().getName()) + " not found");
        }
        if (!this.getFile().isDirectory()) {
            throw new IOException(String.valueOf(this.getFile().getName()) + " not a directory");
        }
        File[] fileArray = iLocatorNameFilter == null ? this.getFile().listFiles() : this.getFile().listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return iLocatorNameFilter.accept(FileLocator.this, string);
            }
        });
        if (fileArray == null) {
            throw new IOException("error listing resources");
        }
        ILocator[] iLocatorArray = new ILocator[fileArray.length];
        int n = 0;
        while (n < iLocatorArray.length) {
            FileLocator fileLocator = new FileLocator(fileArray[n].getPath());
            fileLocator.setSynchSynchronous(this.isSynchSynchronous());
            fileLocator.setEncoding(this.getEncoding());
            iLocatorArray[n] = fileLocator;
            ++n;
        }
        return iLocatorArray;
    }

    public void rename(String string) throws IOException {
        if (this.getFile() == null) {
            return;
        }
        File file = this.getFile().getParentFile();
        if (file == null) {
            file = this.getFile().getAbsoluteFile().getParentFile();
        }
        File file2 = file == null ? new File(string) : new File(file, string);
        FileTools.renameFile(this.getFile(), file2);
        this.file = file2;
        this.canonicalFile = null;
        this.lastModified = 0L;
    }

    protected void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSynchSynchronous(boolean bl) {
        this.synchSynchronous = bl;
    }

    public void setUseTempFile(boolean bl) {
        this.useTempFile = bl;
    }

    public synchronized void synch() {
        if (this.getFile() == null) {
            return;
        }
        if (this.getLastModified() != this.getFile().lastModified()) {
            LogTools.getLogger(this.getClass()).log(Level.FINEST, "'" + this.getFullName() + "' out of synch!");
            this.outOfSynch = true;
        }
    }

    public String toString() {
        return this.getFile().toString();
    }

    public URL toURL() {
        try {
            return new URL("file", null, String.valueOf(this.getFullName()) + "/");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    class FileLocatorLock
    implements ILock {
        private RandomAccessFile ra;

        FileLocatorLock() {
        }

        public boolean acquire(Object object, ILockLevel iLockLevel) {
            try {
                this.ra = new RandomAccessFile(FileLocator.this.getFile(), "r");
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return false;
            }
        }

        public void release(Object object) {
            StreamTools.close(this.ra);
        }
    }
}

