/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LocatorTools {
    public static final String PATH_SEPARATOR = ";";

    public static ILocator[] createLocators(String string, ILocatorFactory iLocatorFactory) throws IOException {
        if (iLocatorFactory == null) {
            iLocatorFactory = LocatorFactory.get();
        }
        ArrayList<ILocator> arrayList = new ArrayList<ILocator>();
        ILocator[] iLocatorArray = new StringTokenizer(string, PATH_SEPARATOR);
        while (iLocatorArray.hasMoreTokens()) {
            String string2 = iLocatorArray.nextToken();
            arrayList.add(iLocatorFactory.createLocator(string2));
        }
        iLocatorArray = new ILocator[arrayList.size()];
        return arrayList.toArray(iLocatorArray);
    }

    public static final File getFile(ILocator iLocator) throws IOException {
        if (iLocator instanceof FileLocator) {
            return ((FileLocator)iLocator).getFile();
        }
        throw new IOException("can't create file for '" + iLocator.getFullName() + "'");
    }

    private LocatorTools() {
    }
}

