/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorViewport
extends CommonLocator
implements IAdapterSupport {
    private ILocator delegate;
    private long start = 0L;
    private long end = -1L;
    private String name;

    public LocatorViewport(ILocator iLocator) {
        this.setDelegate(iLocator);
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.getDelegate().exists();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        return AdapterTools.getAdapter(this.delegate, clazz);
    }

    @Override
    public ILocator getChild(String string) {
        return this.getDelegate().getChild(string);
    }

    public ILocator getDelegate() {
        return this.delegate;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public String getFullName() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getDelegate().getFullName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new InputStreamProxy(this.getDelegate().getInputStream());
    }

    @Override
    public long getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public String getLocalName() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getDelegate().getLocalName();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public ILocator getParent() {
        return this.getDelegate().getParent();
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        return new RandomAccessProxy(this.getDelegate().getRandomAccess());
    }

    @Override
    public Reader getReader() throws IOException {
        return new ReaderProxy(this.getDelegate().getReader());
    }

    @Override
    public Reader getReader(String string) throws IOException {
        return new ReaderProxy(this.getDelegate().getReader(string));
    }

    public long getStart() {
        return this.start;
    }

    @Override
    public String getType() {
        return this.getDelegate().getType();
    }

    @Override
    public String getTypedName() {
        return this.getDelegate().getTypedName();
    }

    @Override
    public Writer getWriter() throws IOException {
        return null;
    }

    @Override
    public Writer getWriter(String string) throws IOException {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.getDelegate().isDirectory();
    }

    @Override
    public boolean isOutOfSynch() {
        return this.getDelegate().isOutOfSynch();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return this.getDelegate().listLocators(iLocatorNameFilter);
    }

    @Override
    public void rename(String string) throws IOException {
        this.getDelegate().rename(string);
    }

    protected void setDelegate(ILocator iLocator) {
        this.delegate = iLocator;
    }

    public void setEnd(long l) {
        try {
            if (l < 0L || l > this.getDelegate().getLength()) {
                throw new IllegalArgumentException("end");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.end = l;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStart(long l) {
        try {
            if (l < 0L || l > this.getDelegate().getLength()) {
                throw new IllegalArgumentException("start");
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.start = l;
    }

    @Override
    public void synch() {
        this.getDelegate().synch();
    }

    @Override
    public URL toURL() {
        return this.getDelegate().toURL();
    }

    private class InputStreamProxy
    extends InputStream {
        private InputStream is;
        private int current = 0;

        public InputStreamProxy(InputStream inputStream) {
            this.is = inputStream;
        }

        public void close() throws IOException {
            this.is.close();
        }

        public int read() throws IOException {
            while ((long)this.current < LocatorViewport.this.getStart()) {
                this.is.read();
                ++this.current;
            }
            if (LocatorViewport.this.getEnd() != -1L && (long)this.current >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            int n = this.is.read();
            ++this.current;
            return n;
        }
    }

    private class RandomAccessProxy
    extends AbstractRandomAccess {
        private IRandomAccess ra;
        private long ptrLocal = 0L;
        private long ptrHost = 0L;

        public RandomAccessProxy(IRandomAccess iRandomAccess) {
            this.ra = iRandomAccess;
            try {
                this.seek(0L);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void close() throws IOException {
            this.ra.close();
        }

        public void flush() throws IOException {
            this.ra.flush();
        }

        public long getLength() throws IOException {
            long l = Math.min(LocatorViewport.this.getEnd(), this.ra.getLength());
            return l - LocatorViewport.this.getStart();
        }

        public long getOffset() throws IOException {
            return this.ra.getOffset() - LocatorViewport.this.getStart();
        }

        public boolean isReadOnly() {
            return true;
        }

        public int read() throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            int n = this.ra.read();
            ++this.ptrHost;
            ++this.ptrLocal;
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            int n = Math.min(byArray.length, (int)LocatorViewport.this.getEnd() - (int)this.ptrHost);
            int n2 = this.ra.read(byArray, 0, n);
            this.ptrHost += (long)n2;
            this.ptrLocal += (long)n2;
            return n2;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.ptrHost < LocatorViewport.this.getStart()) {
                throw new IOException("index out of scope");
            }
            if (LocatorViewport.this.getEnd() != -1L && this.ptrHost >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            n2 = Math.min(n2, (int)LocatorViewport.this.getEnd() - (int)this.ptrHost);
            int n3 = this.ra.read(byArray, n, n2);
            this.ptrHost += (long)n3;
            this.ptrLocal += (long)n3;
            return n3;
        }

        public void seek(long l) throws IOException {
            this.ra.seek(LocatorViewport.this.getStart() + l);
            this.ptrHost = LocatorViewport.this.getStart() + l;
            this.ptrLocal = l;
        }

        public void seekBy(long l) throws IOException {
            this.ra.seek(this.ptrHost + l);
            this.ptrHost += l;
            this.ptrLocal += l;
        }

        public void setLength(long l) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void write(int n) throws IOException {
        }
    }

    private class ReaderProxy
    extends Reader {
        private Reader r;
        private int current = 0;

        public ReaderProxy(Reader reader) {
            this.r = reader;
        }

        public void close() throws IOException {
            this.r.close();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            while ((long)this.current < LocatorViewport.this.getStart()) {
                this.r.read();
                ++this.current;
            }
            if ((long)this.current >= LocatorViewport.this.getEnd()) {
                return -1;
            }
            n2 = Math.min(n2, (int)LocatorViewport.this.getEnd() - this.current);
            int n3 = this.r.read(cArray, n, n2);
            this.current += n3;
            return n3;
        }
    }
}

