/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class StreamLocator
extends CommonLocator {
    private boolean inputUsed = false;
    private boolean outputUsed = false;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private String type;
    private String localName;

    public StreamLocator(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.localName = string;
        this.type = string2;
    }

    public StreamLocator(InputStream inputStream, String string, String string2) {
        this(inputStream, null, string, string2);
    }

    public StreamLocator(OutputStream outputStream, String string, String string2) {
        this(null, outputStream, string, string2);
    }

    public void delete() throws IOException {
    }

    public boolean exists() {
        return this.inputStream != null;
    }

    public ILocator getChild(String string) {
        return null;
    }

    public String getFullName() {
        return this.getLocalName();
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputUsed) {
            throw new IOException("input already requested");
        }
        this.inputUsed = true;
        return this.inputStream;
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputUsed) {
            throw new IOException("output already requested");
        }
        this.outputUsed = true;
        return this.outputStream;
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public Reader getReader(String string) throws IOException {
        return new InputStreamReader(this.getInputStream(), string);
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    public Writer getWriter(String string) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), string);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.outputStream == null;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) {
        return new ILocator[0];
    }

    public void rename(String string) throws IOException {
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string);
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }
}

