/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.LogConfigurator;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class LogTools {
    public static void closeFileLogger(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            handlerArray[n].close();
            ++n;
        }
    }

    public static Logger createFileLogger(String string, String string2, boolean bl) throws SecurityException, IOException {
        Logger logger = Logger.getLogger(string);
        FileHandler fileHandler = new FileHandler(string2, bl);
        logger.addHandler(fileHandler);
        return logger;
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = Logger.getLogger(LogTools.toLoggerName(clazz));
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static String toLoggerName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    private LogTools() {
    }
}

