/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.logging.SimpleFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class MemoryLogHandler
extends Handler
implements INotificationSupport {
    private static final int DEFAULT_SIZE = 1000;
    private int size;
    private String id;
    private LogRecord[] buffer;
    private int start;
    private int count;
    private EventDispatcher dispatcher = new EventDispatcher(this);

    public MemoryLogHandler() {
        this.init();
    }

    public MemoryLogHandler(String string, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = n;
        this.id = string;
        this.init();
    }

    public void addNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        this.dispatcher.addNotificationListener(eventType, iNotificationListener);
    }

    public synchronized void clear() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
        this.triggerChanged(null, null, null);
    }

    public void close() throws SecurityException {
        this.buffer = null;
        this.setLevel(Level.OFF);
    }

    public void flush() {
    }

    public String getId() {
        return this.id;
    }

    public synchronized LogRecord[] getLogRecords() {
        LogRecord[] logRecordArray = new LogRecord[this.count];
        System.arraycopy(this.buffer, this.start, logRecordArray, 0, this.count);
        return logRecordArray;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        LogRecord[] logRecordArray = this.getLogRecords();
        int n = 0;
        while (n < logRecordArray.length) {
            LogRecord logRecord = logRecordArray[n];
            try {
                stringBuilder.append(this.getFormatter().format(logRecord));
            }
            catch (Exception exception) {}
            ++n;
        }
        return stringBuilder.toString();
    }

    private void init() {
        this.setFormatter(new SimpleFormatter());
        this.size = 1000;
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        int n = (this.start + this.count) % this.buffer.length;
        this.buffer[n] = logRecord;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        this.triggerChanged(null, null, logRecord);
    }

    public void removeNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        this.dispatcher.removeNotificationListener(eventType, iNotificationListener);
    }

    public void setId(String string) {
        this.id = string;
    }

    public synchronized void setSize(int n) {
        this.size = n;
    }

    protected void triggerChanged(Object object, Object object2, Object object3) {
        AttributeChangedEvent attributeChangedEvent = new AttributeChangedEvent(this, object, object2, object3);
        this.triggerEvent(attributeChangedEvent);
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException runtimeException) {}
    }
}

