/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.IUnEscaper;
import de.intarsys.tools.stream.StreamTools;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class UnEscapeReader
extends FilterReader
implements IUnEscaper {
    public static final char DefaultEscape = '\\';
    private static final Map DefaultEscapeMap = new HashMap();
    private char escape = (char)92;
    private Map escapeMap = DefaultEscapeMap;
    private boolean mapped = false;
    private boolean open = true;
    private char unicodePrefix = (char)117;

    static {
        DefaultEscapeMap.put(new Character('\\'), new Character('\\'));
        DefaultEscapeMap.put(new Character('n'), new Character('\n'));
        DefaultEscapeMap.put(new Character('r'), new Character('\r'));
        DefaultEscapeMap.put(new Character('t'), new Character('\t'));
        DefaultEscapeMap.put(new Character('\n'), null);
        DefaultEscapeMap.put(new Character('\r'), null);
        DefaultEscapeMap.put(new Character('\t'), null);
        DefaultEscapeMap.put(new Character(' '), null);
    }

    public static String unescape(String string) throws IOException {
        UnEscapeReader unEscapeReader = new UnEscapeReader(new StringReader(string));
        return StreamTools.toString(unEscapeReader);
    }

    public UnEscapeReader(Reader reader) {
        super(reader);
    }

    public UnEscapeReader(Reader reader, char c, Map map) {
        super(reader);
        this.escape = c;
        this.escapeMap = map;
    }

    public UnEscapeReader(Reader reader, Map map) {
        super(reader);
        this.escapeMap = map;
    }

    public void addEscapedCharacter(char c, char c2) {
        Map map = this.getEscapeMap();
        map.put(new Character(c), new Character(c2));
        this.setEscapeMap(map);
    }

    public void close() throws IOException {
        this.in.close();
        this.open = false;
    }

    public char getEscape() {
        return this.escape;
    }

    public Map getEscapeMap() {
        return new HashMap(this.escapeMap);
    }

    public char getUnicodePrefix() {
        return this.unicodePrefix;
    }

    public boolean isMapped() {
        return this.mapped;
    }

    public int read() throws IOException {
        this.mapped = false;
        int n = this.in.read();
        if (n == this.escape) {
            this.mapped = true;
            n = this.readEscaped();
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2 && n4 != -1) {
            n4 = this.read();
            cArray[n3] = (char)n4;
            ++n3;
        }
        if (n4 == -1 && n3 == n) {
            return -1;
        }
        return n3 - n;
    }

    protected int readEscaped() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return -1;
        }
        if ((char)n == '\r') {
            int n2 = this.read();
            if ((char)n2 == '\n' && !this.isMapped()) {
                return this.read();
            }
            return n2;
        }
        if ((char)n == '\n') {
            return this.read();
        }
        if ((char)n == this.getUnicodePrefix()) {
            return this.readHex();
        }
        Character c = new Character((char)n);
        Character c2 = (Character)this.escapeMap.get(c);
        if (c2 == null) {
            if (this.escapeMap.containsKey(c)) {
                return this.read();
            }
            throw new IOException("unrecognized escape sequence: \"\\" + (char)n + "\"");
        }
        return c2.charValue();
    }

    protected int readHex() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.in.read();
        while (((char)n >= '0' && (char)n <= '9' || (char)n >= 'A' && (char)n <= 'F' || (char)n >= 'a' && (char)n <= 'f') && stringBuilder.length() < 4) {
            stringBuilder.append((char)n);
            n = this.in.read();
        }
        if (n == -1) {
            return -1;
        }
        if (stringBuilder.length() < 4) {
            throw new IOException("illegal escape sequence: \"\\u" + stringBuilder.toString() + "\"");
        }
        String string = new String(stringBuilder);
        return Integer.parseInt(string, 16);
    }

    public void removeEscapedCharacter(char c) {
        Map map = this.getEscapeMap();
        map.remove(new Character(c));
        this.setEscapeMap(map);
    }

    public void removeEscapedCharacters() {
        this.setEscapeMap(new HashMap());
    }

    public void setEscape(char c) {
        if (c == this.escape) {
            return;
        }
        Map map = this.getEscapeMap();
        map.remove(new Character(this.getEscape()));
        map.put(new Character(c), new Character(c));
        this.setEscapeMap(map);
        this.escape = c;
    }

    protected void setEscapeMap(Map map) {
        this.escapeMap = map;
    }

    public void setUnicodePrefix(char c) {
        this.unicodePrefix = c;
    }

    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("parameter is negative");
        }
        long l2 = 0L;
        int n = 0;
        while (l2 < l && n != -1) {
            n = this.read();
            ++l2;
        }
        return l2;
    }
}

