/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;
import de.intarsys.tools.reporter.ReportDispatcher;

public class ReplayReporter
implements IReporter,
IReporterSupport {
    private ReportDispatcher dispatcher = new ReportDispatcher(this);
    private String reportStatusMessage;
    private int reportStatusStyle;
    private String reportActivityMessage;
    private int reportActivityStyle;
    private String reportProgressMessage;
    private int reportProgressPercent;
    private int reportProgressStyle;
    private String reportErrorTitle;
    private String reportErrorMessage;
    private Throwable reportErrorThrowable;
    private int reportErrorStyle;
    private String reportMessageTitle;
    private String reportMessageMessage;
    private int reportMessageStyle;

    public void addReporter(IReporter iReporter) {
        this.dispatcher.addReporter(iReporter);
        this.replay(iReporter);
    }

    public void removeReporter(IReporter iReporter) {
        this.dispatcher.removeReporter(iReporter);
    }

    protected void replay(IReporter iReporter) {
        if (this.reportActivityMessage != null) {
            iReporter.reportActivityStart(this.reportActivityMessage, this.reportActivityStyle);
        }
        if (this.reportProgressMessage != null) {
            iReporter.reportProgress(this.reportProgressMessage, this.reportProgressPercent, this.reportProgressStyle);
        }
        if (this.reportStatusMessage != null) {
            iReporter.reportStatus(this.reportStatusMessage, this.reportStatusStyle);
        }
        if (this.reportMessageMessage != null) {
            iReporter.reportMessage(this.reportMessageTitle, this.reportMessageMessage, this.reportMessageStyle);
        }
        if (this.reportErrorMessage != null) {
            iReporter.reportError(this.reportErrorTitle, this.reportErrorMessage, this.reportErrorThrowable, this.reportErrorStyle);
        }
    }

    public void reportActivityEnd() {
        this.reportActivityMessage = null;
        this.dispatcher.reportActivityEnd();
    }

    public void reportActivityStart(String string, int n) {
        this.reportActivityMessage = string;
        this.reportActivityStyle = n;
        this.dispatcher.reportActivityStart(string, n);
    }

    public void reportError(String string, String string2, Throwable throwable, int n) {
        this.reportErrorTitle = string;
        this.reportErrorMessage = string2;
        this.reportErrorThrowable = throwable;
        this.reportErrorStyle = n;
        this.dispatcher.reportError(string, string2, throwable, n);
    }

    public void reportMessage(String string, String string2, int n) {
        this.reportMessageTitle = string;
        this.reportMessageMessage = string2;
        this.reportMessageStyle = n;
        this.dispatcher.reportMessage(string, string2, n);
    }

    public void reportProgress(String string, int n, int n2) {
        if (n < 0) {
            this.reportProgressMessage = null;
            this.reportProgressPercent = -1;
            this.reportProgressStyle = n2;
        } else {
            this.reportProgressMessage = string;
            this.reportProgressPercent = n;
            this.reportProgressStyle = n2;
        }
        this.dispatcher.reportProgress(string, n, n2);
    }

    public void reportStatus(String string, int n) {
        this.reportStatusMessage = string;
        this.reportStatusStyle = n;
        this.dispatcher.reportStatus(string, n);
    }
}

