/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;

public class MindMapNodesSelection
implements Transferable,
ClipboardOwner {
    private String nodesContent;
    private String stringContent;
    private String rtfContent;
    private String htmlContent;
    private String dropActionContent;
    private final List fileList;
    public static DataFlavor mindMapNodesFlavor = null;
    public static DataFlavor rtfFlavor = null;
    public static DataFlavor htmlFlavor = null;
    public static DataFlavor fileListFlavor = null;
    public static DataFlavor dropActionFlavor = null;
    public static DataFlavor uriListFlavor = null;
    private static final String URI_LIST = "uri-list";

    public MindMapNodesSelection(String nodesContent, String stringContent, String rtfContent, String htmlContent, String dropActionContent, List fileList) {
        this.nodesContent = nodesContent;
        this.rtfContent = rtfContent;
        this.stringContent = stringContent;
        this.dropActionContent = dropActionContent;
        this.htmlContent = htmlContent;
        this.fileList = fileList;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.stringContent;
        }
        if (flavor.equals(mindMapNodesFlavor)) {
            return this.nodesContent;
        }
        if (flavor.equals(dropActionFlavor)) {
            return this.dropActionContent;
        }
        if (flavor.equals(rtfFlavor)) {
            byte[] byteArray = this.rtfContent.getBytes();
            return new ByteArrayInputStream(byteArray);
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return this.htmlContent;
        }
        if (flavor.equals(fileListFlavor)) {
            return this.fileList;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.stringFlavor, mindMapNodesFlavor, rtfFlavor, htmlFlavor, dropActionFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.stringFlavor) && this.stringContent != null) {
            return true;
        }
        if (flavor.equals(mindMapNodesFlavor) && this.nodesContent != null) {
            return true;
        }
        if (flavor.equals(rtfFlavor) && this.rtfContent != null) {
            return true;
        }
        if (flavor.equals(dropActionFlavor) && this.dropActionContent != null) {
            return true;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return true;
        }
        return flavor.equals(fileListFlavor) && this.fileList != null && this.fileList.size() > 0;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDropAction(String dropActionContent) {
        this.dropActionContent = dropActionContent;
    }

    public static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>(1);
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<File> importData(Transferable t) {
        LinkedList<File> files = null;
        try {
            for (DataFlavor flavor : t.getTransferDataFlavors()) {
                Object obj = t.getTransferData(flavor);
                if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                    files = (LinkedList<File>)t.getTransferData(flavor);
                    continue;
                }
                if (!URI_LIST.equals(flavor.getSubType()) || !(obj instanceof String)) continue;
                String urilist = (String)obj;
                Scanner scanner = new Scanner(urilist.trim());
                files = new LinkedList<File>();
                while (scanner.hasNextLine()) {
                    files.add(new File(new URI(scanner.nextLine())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    static {
        try {
            mindMapNodesFlavor = new DataFlavor("text/freemind-nodes; class=java.lang.String");
            rtfFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
            htmlFlavor = new DataFlavor("text/html; class=java.lang.String");
            fileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List");
            dropActionFlavor = new DataFlavor("text/drop-action; class=java.lang.String");
            uriListFlavor = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

