/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.mindmapmode.hooks.PermanentMindMapNodeHookAdapter;
import freemind.view.mindmapview.NodeView;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class FormularEditor
extends PermanentMindMapNodeHookAdapter {
    private static final String XML_FORMULAR_TYPE = "TYPE";
    private JPanel panel;
    private List entities = new Vector();

    @Override
    public void loadFrom(XMLElement child) {
        super.loadFrom(child);
        this.entities.clear();
        for (int i = 0; i < child.getChildren().size(); ++i) {
            String type;
            XMLElement paramChild = (XMLElement)child.getChildren().get(i);
            if (paramChild == null || (type = paramChild.getStringAttribute(XML_FORMULAR_TYPE)) == null) continue;
            if (type.equals("string")) {
                this.entities.add(new StringEntity(paramChild));
                continue;
            }
            if (type.equals("enumerator")) {
                this.entities.add(new ChoiceEntity(paramChild));
                continue;
            }
            if (!type.equals("checkbox")) continue;
            this.entities.add(new CheckBoxEntity(paramChild));
        }
    }

    @Override
    public void save(XMLElement xml) {
        super.save(xml);
        for (FormularEntity entity : this.entities) {
            XMLElement child = new XMLElement();
            child.setName("formular");
            entity.save(child);
            xml.addChild(child);
        }
    }

    @Override
    public void onDeselectHook(NodeView nodeView) {
        super.onDeselectHook(nodeView);
        this.shutDownDisplay();
    }

    private void shutDownDisplay() {
        if (this.panel != null) {
            this.panel.setVisible(false);
            FreeMindMain frame = this.getController().getFrame();
            frame.removeSplitPane();
            this.panel = null;
        }
    }

    @Override
    public void onSelectHook(NodeView nodeView) {
        super.onSelectHook(nodeView);
        if (this.panel == null) {
            this.panel = new JPanel(null);
            GridBagLayout gridbag = new GridBagLayout();
            int y = 0;
            for (FormularEntity entity : this.entities) {
                entity.addToPanel(this.panel, gridbag, y);
                ++y;
            }
            this.panel.setLayout(gridbag);
            FreeMindMain frame = this.getController().getFrame();
            frame.insertComponentIntoSplitPane(this.panel);
        }
    }

    @Override
    public void shutdownMapHook() {
        this.shutDownDisplay();
        super.shutdownMapHook();
    }

    private class ChoiceEntity
    extends FormularEntity {
        ChoiceElement[] possibles;

        @Override
        public void addToPanel(JPanel panel, GridBagLayout l, int y) {
            super.addToPanel(panel, l, y);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.weightx = 100.0;
            c.weighty = 100.0;
            c.fill = 1;
            final JComboBox<String> choice = new JComboBox<String>();
            int found = -1;
            for (int i = 0; i < this.possibles.length; ++i) {
                String itemName = this.possibles[i].enumStr;
                if (this.possibles[i].displayValue != null) {
                    itemName = this.possibles[i].displayValue;
                }
                choice.addItem(itemName);
                if (!this.possibles[i].enumStr.equals(this.getValue())) continue;
                found = i;
            }
            if (found < 0) {
                throw new IllegalArgumentException("Enum " + this.getValue() + " not found in possibles " + this.possibles);
            }
            choice.setSelectedIndex(found);
            l.setConstraints(choice, c);
            panel.add(choice);
            choice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChoiceEntity.this.setValue(ChoiceEntity.this.possibles[choice.getSelectedIndex()].enumStr);
                    FormularEditor.this.nodeChanged(FormularEditor.this.getNode());
                }
            });
        }

        public ChoiceEntity(XMLElement paramChild) {
            super(paramChild);
            this.possibles = new ChoiceElement[paramChild.getChildren().size()];
            for (int i = 0; i < paramChild.getChildren().size(); ++i) {
                XMLElement child = (XMLElement)paramChild.getChildren().get(i);
                if (child == null) continue;
                this.possibles[i] = new ChoiceElement(child);
            }
        }

        @Override
        public void save(XMLElement child) {
            super.save(child);
            for (int i = 0; i < this.possibles.length; ++i) {
                XMLElement enumChild = new XMLElement();
                enumChild.setName("value");
                this.possibles[i].save(enumChild);
                child.addChild(enumChild);
            }
        }

        private class ChoiceElement {
            public String enumStr;
            public String displayValue;

            public ChoiceElement(XMLElement child) {
                this.enumStr = child.getStringAttribute("ENUM");
                this.displayValue = child.getStringAttribute("DISPLAY");
            }

            public void save(XMLElement enumChild) {
                enumChild.setAttribute("ENUM", this.enumStr);
                enumChild.setAttribute("DISPLAY", this.displayValue);
            }
        }
    }

    private class CheckBoxEntity
    extends FormularEntity {
        public CheckBoxEntity(XMLElement paramChild) {
            super(paramChild);
        }

        @Override
        public void addToPanel(JPanel panel, GridBagLayout l, int y) {
            super.addToPanel(panel, l, y);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.weightx = 100.0;
            c.weighty = 100.0;
            c.fill = 1;
            JCheckBox text = new JCheckBox();
            text.setSelected(this.getValue().equals("true"));
            l.setConstraints(text, c);
            panel.add(text);
            text.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        CheckBoxEntity.this.setValue("false");
                    } else {
                        CheckBoxEntity.this.setValue("true");
                    }
                }
            });
        }
    }

    private class StringEntity
    extends FormularEntity {
        @Override
        public void addToPanel(JPanel panel, GridBagLayout l, int y) {
            super.addToPanel(panel, l, y);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = y;
            c.weightx = 100.0;
            c.weighty = 100.0;
            c.fill = 1;
            JTextField text = new JTextField(this.getValue());
            l.setConstraints(text, c);
            panel.add(text);
            text.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent arg0) {
                    this.changedUpdate(arg0);
                }

                @Override
                public void removeUpdate(DocumentEvent arg0) {
                    this.changedUpdate(arg0);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    try {
                        String text = e.getDocument().getText(0, e.getDocument().getLength());
                        StringEntity.this.setValue(text);
                        FormularEditor.this.nodeChanged(FormularEditor.this.getNode());
                    }
                    catch (BadLocationException e1) {
                        Resources.getInstance().logException(e1);
                    }
                }
            });
        }

        public StringEntity(XMLElement paramChild) {
            super(paramChild);
        }
    }

    private abstract class FormularEntity {
        private String value;
        private String label;
        private String type;
        private String displayLabel;

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String string) {
            this.label = string;
        }

        public FormularEntity(String name, String value, String type, String display) {
            this.label = name;
            this.value = value;
            this.type = type;
            this.displayLabel = display;
        }

        public void addToPanel(JPanel panel, GridBagLayout l, int y) {
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y;
            c.weightx = 50.0;
            c.weighty = 100.0;
            c.fill = 3;
            c.anchor = 13;
            JLabel jlabel = new JLabel(this.getLabel());
            if (this.getDisplayLabel() != null) {
                jlabel.setText(this.getDisplayLabel());
            }
            l.setConstraints(jlabel, c);
            panel.add(jlabel);
        }

        public void save(XMLElement child) {
            child.setAttribute("NAME", this.getLabel());
            child.setAttribute("VALUE", this.getValue());
            if (this.getDisplayLabel() != null) {
                child.setAttribute("DISPLAY", this.getDisplayLabel());
            }
            child.setAttribute(FormularEditor.XML_FORMULAR_TYPE, this.getType());
        }

        private String getDisplayLabel() {
            return this.displayLabel;
        }

        public FormularEntity(XMLElement paramChild) {
            this(paramChild.getStringAttribute("NAME"), paramChild.getStringAttribute("VALUE"), paramChild.getStringAttribute(FormularEditor.XML_FORMULAR_TYPE), paramChild.getStringAttribute("DISPLAY"));
        }

        public String getType() {
            return this.type;
        }

        public void setDisplayLabel(String string) {
            this.displayLabel = string;
        }
    }
}

