/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.PdfFileFilter;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;

public class UpdateMonitoringDirAction
extends AbstractMonitoringAction {
    private MindMapNode selected;

    public UpdateMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_update"), controller);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.controller.getSelected();
        this.directory = new File(this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH));
        if (!this.directory.exists()) {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_dirNotFound"));
            this.RemoveMonitoringAtrributes(this.selected);
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
        this.ExecuteMyTask(new MyTask());
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        List<File> monDirFiles;
        List<MindMapNode> monDirFilesLinkedNodes;
        List<BibTex> bibTexList;
        MindMapNode node;
        MindMapNode equalNode;
        PdfFileFilter pdfFilter = new PdfFileFilter();

        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.bibTexList = BookmarkMindMapNode.ReadBibtexFile();
            this.monDirFilesLinkedNodes = this.getNodesLinkedToMonDirFiles(UpdateMonitoringDirAction.this.controller.getRootNode());
            this.monDirFiles = this.getMonDirFilesFromDir(UpdateMonitoringDirAction.this.directory);
            for (File monDirFile : this.monDirFiles) {
                this.equalNode = UpdateMonitoringDirAction.this.GetEqualNodeFromList(this.monDirFilesLinkedNodes, monDirFile);
                if (this.equalNode == null) {
                    this.node = this.pdfFilter.accept(monDirFile) ? this.ImportBookmarksFromFile(monDirFile, this.bibTexList) : new BookmarkMindMapNode(monDirFile.getPath(), monDirFile.getName(), UpdateMonitoringDirAction.this.controller.getController());
                    if (this.node == null) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UpdateMonitoringDirAction.this.controller.paste(MyTask.this.node, UpdateMonitoringDirAction.this.selected);
                            UpdateMonitoringDirAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                        }
                    });
                    continue;
                }
                if (!this.pdfFilter.accept(this.equalNode.getLink())) continue;
                SplmmAttributes splmmAttributes = this.equalNode.getSPLMMAttributes();
                Date monDirFileLastModified = new Date(monDirFile.lastModified());
                if (splmmAttributes != null && !splmmAttributes.getBookmarksUpdated().before(monDirFileLastModified) || !UpdateMonitoringDirAction.this.monDirNodeIsParent(UpdateMonitoringDirAction.this.selected, this.equalNode)) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        UpdateMonitoringDirAction.this.importBookmarks(MyTask.this.equalNode);
                    }
                });
            }
            return null;
        }
    }
}

