/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import freemind.controller.Controller;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.NodeView;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import splmm.BibTex;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class BookmarkMindMapNode
extends MindMapNodeModel {
    private String name;

    public BookmarkMindMapNode(String path, String name, Controller c) {
        super(c.getFrame(), c.getMap());
        this.name = name;
        this.setLink(path);
        this.setText(name);
    }

    public BookmarkMindMapNode(String path, String name, BibTex bibtex, Controller c) {
        super(c.getFrame(), c.getMap());
        this.name = name;
        this.createAttributeTableModel();
        Attribute pAttribute = new Attribute(SciPloreUtils.SPLMM_REFKEY_NAME, bibtex.getKey());
        this.getAttributes().addRowNoUndo(pAttribute);
        if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
            pAttribute = new Attribute("splmm_reftitle", bibtex.getTitle());
            this.getAttributes().addRowNoUndo(pAttribute);
        }
        BookmarkMindMapNode.SetOptimalColumnWidth(this, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
        if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
            BookmarkMindMapNode.SetOptimalColumnWidth(this, bibtex.getTitle(), "splmm_reftitle");
        }
        this.setLink(path);
        this.setText(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static ArrayList<MindMapNode> getBookmarksFromFiles(List<File> fileList, Controller c) {
        List<BibTex> bibTexList = BookmarkMindMapNode.ReadBibtexFile();
        ArrayList<MindMapNode> bookmarklist = new ArrayList<MindMapNode>();
        for (File file : fileList) {
            MindMapNode node = BookmarkMindMapNode.getBookmarksFromFile(file, c, bibTexList);
            if (node == null) continue;
            bookmarklist.add(node);
        }
        return bookmarklist;
    }

    public static MindMapNode getBookmarksFromFile(File file, Controller c) {
        List<BibTex> bibTexList = BookmarkMindMapNode.ReadBibtexFile();
        return BookmarkMindMapNode.getBookmarksFromFile(file, c, bibTexList);
    }

    public static MindMapNode getBookmarksFromFile(File file, Controller c, List<BibTex> bibTexList) {
        for (BibTex bib : bibTexList) {
            if (!bib.getPath().contains(file.getName())) continue;
            BookmarkMindMapNode node = BookmarkMindMapNode.getBookmarks(file, true, bib, c);
            if (node != null) {
                node.getSPLMMAttributes().setBookmarksUpdated(new Date());
            }
            return node;
        }
        return BookmarkMindMapNode.getBookmarks(file, false, null, c);
    }

    public static BookmarkMindMapNode getBookmarks(File file, Boolean ref, BibTex bibtex, Controller c) {
        String path = file.getPath();
        BookmarkMindMapNode node = new BookmarkMindMapNode(file.getPath(), file.getName(), c);
        FileLocator locator = new FileLocator(path);
        try {
            PDDocument document = PDDocument.createFromLocator((ILocator)locator);
            PDOutline outline = document.getOutline();
            if (outline != null) {
                if (ref.booleanValue()) {
                    node = new BookmarkMindMapNode(path, file.getName(), bibtex, c);
                    BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                    if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
                        BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getTitle(), "splmm_reftitle");
                    }
                } else {
                    node = new BookmarkMindMapNode(path, file.getName(), c);
                }
                node = BookmarkMindMapNode.helpGetBookmarks(path, (PDOutlineNode)outline, node, ref, bibtex, c);
            }
            if (outline == null) {
                node = new BookmarkMindMapNode(path, file.getName(), c);
            }
            document.close();
        }
        catch (COSLoadException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, (Exception)((Object)e), Level.WARNING);
        }
        catch (IOException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        return node;
    }

    private static BookmarkMindMapNode helpGetBookmarks(String path, PDOutlineNode parent, BookmarkMindMapNode node, Boolean ref, BibTex bibtex, Controller c) {
        List children = parent.getChildren();
        for (PDOutlineItem child : children) {
            BookmarkMindMapNode childNode;
            if (ref.booleanValue()) {
                childNode = new BookmarkMindMapNode(path, child.getTitle(), bibtex, c);
                BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
                    BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getTitle(), "splmm_reftitle");
                }
            } else {
                childNode = new BookmarkMindMapNode(path, child.getTitle(), c);
            }
            childNode = BookmarkMindMapNode.helpGetBookmarks(path, (PDOutlineNode)child, childNode, ref, bibtex, c);
            node.insert(childNode, node.getChildCount());
        }
        return node;
    }

    public static List<BibTex> ReadBibtexFile() {
        List<BibTex> bibTexList = new ArrayList<BibTex>();
        if (SplmmPreferences.getJabRefPath() != null && !SplmmPreferences.getJabRefPath().equals("")) {
            File f = new File(SplmmPreferences.getJabRefPath());
            BibTex bib = new BibTex();
            bibTexList = bib.readBibtex(f);
        }
        return bibTexList;
    }

    public static void SetOptimalColumnWidth(MindMapNode node, String value, String key) {
        ModeController controller = node.getMap().getModeController();
        NodeView nodeView = controller.getNodeView(controller.getSelected());
        FontMetrics fontMetrics = nodeView.getFontMetrics(nodeView.getTextFont());
        int optCellWidthLeft = fontMetrics.stringWidth(key + "O");
        int optCellWidthRight = fontMetrics.stringWidth(value + "O");
        node.getAttributes().setColumnWidth(0, optCellWidthLeft);
        node.getAttributes().setColumnWidth(1, optCellWidthRight);
    }
}

