/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import freemind.main.FreeMindMain;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;

public class Preferences
extends JDialog {
    private JButton bibTeXFileButton;
    private JCheckBox updateCheckBox;
    private JCheckBox usageMiningCheckBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton privacyButton;
    private JCheckBox backupCheckBox;
    private JCheckBox ironmmCheckBox;
    private JCheckBox ironldCheckBox;
    private JPanel contentPane;
    private JLabel notifyInfoLabel;
    private JLabel backupInfoLabel;
    private JLabel usageMiningInfoLabel;
    private JLabel ironmmInfoLabel;
    private JLabel ironldInfoLabel;
    private JTextField userNameTextField;
    private JPasswordField backupPasswordField;
    private JLabel registerLinkLabel;
    private JTextField jabrefpathTextField;
    private FreeMindMain freemind;

    public Preferences(FreeMindMain freemind) {
        this.$$$setupUI$$$();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onCancel();
            }
        });
        this.bibTeXFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onBibTeXFile();
            }
        });
        this.privacyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onPrivacy();
            }
        });
        this.backupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onBackUp();
            }
        });
        this.backupPasswordField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    Preferences.this.backupPasswordField.setText("");
                }
            }
        });
        this.registerLinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.registerLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SciPloreUtils.openURL(LocalizationSupport.message("http.www.sciplore.org.register.en.php"));
                }
            }
        });
        this.notifyInfoLabel.addMouseListener(new PreferencesMouseListener(freemind, "splmm_preferences_notifyInfoText"));
        this.backupInfoLabel.addMouseListener(new PreferencesMouseListener(freemind, "splmm_preferences_backupInfoText"));
        this.usageMiningInfoLabel.addMouseListener(new PreferencesMouseListener(freemind, "splmm_preferences_usageMiningInfoText"));
        this.ironmmInfoLabel.addMouseListener(new PreferencesMouseListener(freemind, "splmm_preferences_ironmmInfoText"));
        this.ironldInfoLabel.addMouseListener(new PreferencesMouseListener(freemind, "splmm_preferences_ironldInfoText"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.loadUserData();
        this.freemind = freemind;
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(freemind.getJFrame());
        this.pack();
        this.setVisible(true);
    }

    private void loadUserData() {
        this.jabrefpathTextField.setText(SplmmPreferences.getJabRefPath());
        this.updateCheckBox.setSelected(SplmmPreferences.getUpdateInfo());
        this.backupCheckBox.setSelected(SplmmPreferences.getAllowBackup());
        this.usageMiningCheckBox.setSelected(SplmmPreferences.getAllowUsageMining());
        this.ironmmCheckBox.setSelected(SplmmPreferences.getAllowIRonMM());
        this.ironldCheckBox.setSelected(SplmmPreferences.getAllowIRonLD());
        this.userNameTextField.setEnabled(SplmmPreferences.getAllowBackup());
        this.backupPasswordField.setEnabled(SplmmPreferences.getAllowBackup());
        if (SplmmPreferences.getAllowBackup().booleanValue()) {
            this.userNameTextField.setText(SplmmPreferences.getUserName());
            this.backupPasswordField.setText(SplmmPreferences.getPassword());
        }
    }

    private void onOK() {
        UserDataState userDataState = new UserDataState(this);
        if (userDataState.isUserDataUpdateNeeded().booleanValue()) {
            switch (userDataState.getNewState()) {
                case 1: {
                    if (SplmmPreferences.validateBackupEntry(this.userNameTextField.getText(), String.valueOf(this.backupPasswordField.getPassword()))) break;
                    return;
                }
                case 2: {
                    SplmmPreferences.createUUID();
                    break;
                }
                case 3: {
                    SplmmPreferences.setCredentialsValidated(false);
                    SplmmPreferences.setUserName(LocalizationSupport.message("anonymous"));
                }
            }
        }
        if (!SplmmPreferences.getUpdateInfo().booleanValue() && this.updateCheckBox.isSelected()) {
            SciPloreUtils.checkForUpdate(this.freemind);
        }
        SplmmPreferences.setAllowUsageMining(this.usageMiningCheckBox.isSelected());
        SplmmPreferences.setUpdateInfo(this.updateCheckBox.isSelected());
        SplmmPreferences.setJabRefPath(this.jabrefpathTextField.getText());
        SplmmPreferences.setAllowBackup(this.backupCheckBox.isSelected());
        SplmmPreferences.setAllowIRonMM(this.ironmmCheckBox.isSelected());
        SplmmPreferences.setAllowIRonLD(this.ironldCheckBox.isSelected());
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }

    private void onBibTeXFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("BibTeX file", "bib"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.jabrefpathTextField.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onPrivacy() {
        SciPloreUtils.openURL(SciPloreUtils.PRIVACY_URL);
    }

    private void onBackUp() {
        this.userNameTextField.setEnabled(this.backupCheckBox.isSelected());
        this.backupPasswordField.setEnabled(this.backupCheckBox.isSelected());
    }

    public JCheckBox getBackupCheckBox() {
        return this.backupCheckBox;
    }

    public JCheckBox getIronmmCheckBox() {
        return this.ironmmCheckBox;
    }

    public JPasswordField getBackupPasswordField() {
        return this.backupPasswordField;
    }

    public JTextField getUserNameTextField() {
        return this.userNameTextField;
    }

    public JCheckBox getIronldCheckBox() {
        return this.ironldCheckBox;
    }

    public JCheckBox getUsageMiningCheckBox() {
        return this.usageMiningCheckBox;
    }

    private void createUIComponents() {
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(17, 4, new Insets(20, 20, 20, 20), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_BibTexText"));
        panel1.add((Component)label1, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_helpText"));
        panel1.add((Component)label2, new GridConstraints(9, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_notImplemented"));
        panel1.add((Component)label3, new GridConstraints(13, 2, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel2, new GridConstraints(15, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.okButton = new JButton();
        this.$$$loadButtonText$$$(this.okButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_update_ok"));
        panel2.add((Component)this.okButton, new GridConstraints(0, 4, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.cancelButton = new JButton();
        this.$$$loadButtonText$$$(this.cancelButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("cancel"));
        panel2.add((Component)this.cancelButton, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.privacyButton = new JButton();
        this.$$$loadButtonText$$$(this.privacyButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_moreInfo"));
        panel2.add((Component)this.privacyButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel3, new GridConstraints(3, 2, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.updateCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.updateCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_notify"));
        this.updateCheckBox.setToolTipText("");
        panel3.add((Component)this.updateCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.notifyInfoLabel = new JLabel();
        this.notifyInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.notifyInfoLabel.setText("");
        panel3.add((Component)this.notifyInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel4, new GridConstraints(4, 2, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.backupCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.backupCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_backup"));
        this.backupCheckBox.setToolTipText("");
        panel4.add((Component)this.backupCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.backupInfoLabel = new JLabel();
        this.backupInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.backupInfoLabel.setText("");
        panel4.add((Component)this.backupInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel5, new GridConstraints(10, 2, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.usageMiningCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.usageMiningCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_prferences_usageMining"));
        this.usageMiningCheckBox.setToolTipText("");
        panel5.add((Component)this.usageMiningCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.usageMiningInfoLabel = new JLabel();
        this.usageMiningInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.usageMiningInfoLabel.setText("");
        panel5.add((Component)this.usageMiningInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel6, new GridConstraints(11, 2, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.ironmmCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironmmCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationMindMaps"));
        this.ironmmCheckBox.setToolTipText("");
        panel6.add((Component)this.ironmmCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.ironmmInfoLabel = new JLabel();
        this.ironmmInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironmmInfoLabel.setText("");
        panel6.add((Component)this.ironmmInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel7, new GridConstraints(12, 2, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.ironldCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironldCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationLinkedData"));
        this.ironldCheckBox.setToolTipText("");
        panel7.add((Component)this.ironldCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.ironldInfoLabel = new JLabel();
        this.ironldInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironldInfoLabel.setText("");
        panel7.add((Component)this.ironldInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel8, new GridConstraints(7, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label4 = new JLabel();
        this.$$$loadLabelText$$$(label4, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_username"));
        panel8.add((Component)label4, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        this.$$$loadLabelText$$$(label5, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_password"));
        panel8.add((Component)label5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.backupPasswordField = new JPasswordField();
        panel8.add((Component)this.backupPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.userNameTextField = new JTextField();
        panel8.add((Component)this.userNameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel9 = new JPanel();
        panel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel1.add((Component)panel9, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.bibTeXFileButton = new JButton();
        this.$$$loadButtonText$$$(this.bibTeXFileButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_BibTexButton"));
        panel9.add((Component)this.bibTeXFileButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.jabrefpathTextField = new JTextField();
        panel9.add((Component)this.jabrefpathTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.registerLinkLabel = new JLabel();
        this.registerLinkLabel.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(this.registerLinkLabel, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_registerLink"));
        this.registerLinkLabel.setVerticalTextPosition(0);
        panel1.add((Component)this.registerLinkLabel, new GridConstraints(6, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        panel1.add((Component)spacer1, new GridConstraints(5, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 15), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(8, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 15), null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel1.add((Component)spacer3, new GridConstraints(14, 2, 1, 1, 0, 2, 1, 4, new Dimension(-1, 15), null, null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private class PreferencesMouseListener
    implements MouseListener {
        private FreeMindMain freemind;
        private String resourceKey;

        public PreferencesMouseListener(FreeMindMain freemind, String resourceKey) {
            this.freemind = freemind;
            this.resourceKey = resourceKey;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JOptionPane.showMessageDialog(null, LocalizationSupport.message(this.resourceKey));
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Preferences.this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Preferences.this.setCursor(new Cursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }
}

