/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.ws.rs.core.MediaType;
import org.jetbrains.annotations.NonNls;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;

@NonNls
public class SciPloreWebClient {
    private static Client CLIENT = Client.create();
    private static WebResource WEBRESOURCE = CLIENT.resource("http://api.sciplore.org/rest/");
    private static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private static final String ALLOW_IR = "allowIR";
    private static final String BACKUP = "backup";
    private static final String MIND_MAP = "mindMap";
    private static final String USER_TYPE = "userType";
    private static final String ANONYMOUS_USER_TYPE = "3";
    private static final String FILENAME = "filename";

    public static String postMindMap(String mindmap, String fileName) {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
            return null;
        }
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field(USER_NAME, SplmmPreferences.getUserName());
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + SplmmPreferences.getUserName() + "/mindmaps").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            String mindmapID = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                return mindmapID;
            }
        }
        catch (ClientHandlerException e) {
            SciPloreUtils.logException(SciPloreWebClient.class.getName(), (Exception)((Object)e), Level.WARNING);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void putMindMap(String mindmap, String mindmapID, String fileName) {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
            return;
        }
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field(USER_NAME, SplmmPreferences.getUserName());
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + SplmmPreferences.getUserName() + "/mindmaps/" + mindmapID).type(MediaType.MULTIPART_FORM_DATA_TYPE).put(ClientResponse.class, (Object)formDataMultiPart);
            String string = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() != ClientResponse.Status.OK) return;
        }
        catch (ClientHandlerException e) {
            SciPloreUtils.logException(SciPloreWebClient.class.getName(), (Exception)((Object)e), Level.WARNING);
        }
    }

    public static Boolean validateUserData(String username, String password) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)PASSWORD, (Object)password);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user").put(ClientResponse.class, (Object)formParams);
            switch (response.getClientResponseStatus()) {
                case BAD_REQUEST: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.is.not.allowed.to.be.empty"), LocalizationSupport.message("error"), 0);
                    return false;
                }
                case UNAUTHORIZED: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.or.password.wrong"), LocalizationSupport.message("error"), 0);
                    return false;
                }
                case OK: {
                    username = (String)response.getEntity(String.class);
                    SplmmPreferences.setCredentialsValidated(true);
                    return true;
                }
            }
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("could.not.validate.user.name.and.password.to.backup.mindmap"), LocalizationSupport.message("problem"), 0);
            return true;
        }
        catch (ClientHandlerException e) {
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("could.not.validate.user.name.and.password"), LocalizationSupport.message("problem"), 0);
            return true;
        }
    }

    public static Boolean createAnonymousUser(String username) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)USER_TYPE, (Object)ANONYMOUS_USER_TYPE);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + username).post(ClientResponse.class, (Object)formParams);
            switch (response.getClientResponseStatus()) {
                case BAD_REQUEST: {
                    return false;
                }
                case OK: {
                    SplmmPreferences.setCredentialsValidated(true);
                    return true;
                }
            }
            return true;
        }
        catch (ClientHandlerException e) {
            return true;
        }
    }
}

