/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.action;

import de.intarsys.pdf.app.action.ActionException;
import de.intarsys.pdf.app.action.ActionHandlerRegistry;
import de.intarsys.pdf.app.action.ActionTools;
import de.intarsys.pdf.app.action.IActionHandler;
import de.intarsys.pdf.app.action.IActionHandlerRegistry;
import de.intarsys.pdf.app.action.IActionProcessor;
import de.intarsys.pdf.app.action.PACKAGE;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardActionProcessor
implements IActionProcessor {
    private static Logger Log = PACKAGE.Log;
    private IActionHandlerRegistry factory = ActionHandlerRegistry.get();

    protected IActionHandlerRegistry getFactory() {
        return this.factory;
    }

    protected void handleException(ActionException actionException) {
        Log.logp(Level.WARNING, "", "", "PDF action processing error", actionException);
    }

    protected void processAction(TriggerEvent triggerEvent, COSName cOSName, COSObject cOSObject) {
        COSDocument cOSDocument = cOSObject.getDoc();
        if (cOSDocument != null && !ActionTools.isEnabled(cOSDocument, cOSName)) {
            return;
        }
        IActionHandler iActionHandler = this.getFactory().lookupActionHandler(cOSName);
        if (iActionHandler != null) {
            try {
                iActionHandler.process(triggerEvent, cOSObject);
            }
            catch (ActionException actionException) {
                this.handleException(actionException);
            }
        }
    }

    public void process(TriggerEvent triggerEvent, COSName cOSName, COSObject cOSObject) {
        COSDictionary cOSDictionary;
        PDAction pDAction;
        List list;
        this.processAction(triggerEvent, cOSName, cOSObject);
        if (cOSObject instanceof COSDictionary && (list = (pDAction = (PDAction)PDAction.META.createFromCos(cOSDictionary = (COSDictionary)cOSObject)).getNext()) != null) {
            for (PDAction pDAction2 : list) {
                this.process(triggerEvent, pDAction2.cosGetActionType(), pDAction2.cosGetObject());
            }
        }
        triggerEvent.setExecuted(true);
    }
}

