/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.IAppearanceCreatorRegistry;
import de.intarsys.pdf.cos.COSName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.Service;

public class StandardAppearanceCreatorRegistry
implements IAppearanceCreatorRegistry {
    private Map<COSName, IAppearanceCreator> instances = new HashMap<COSName, IAppearanceCreator>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected StandardAppearanceCreatorRegistry() {
    }

    protected IAppearanceCreator[] findProviders() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ArrayList<IAppearanceCreator> arrayList = new ArrayList<IAppearanceCreator>();
        Iterator iterator = Service.providers(IAppearanceCreator.class, (ClassLoader)classLoader);
        while (iterator.hasNext()) {
            try {
                arrayList.add((IAppearanceCreator)iterator.next());
            }
            catch (Throwable throwable) {}
        }
        return arrayList.toArray(new IAppearanceCreator[arrayList.size()]);
    }

    public synchronized IAppearanceCreator[] getAppearanceCreators() {
        this.init();
        return this.instances.values().toArray(new IAppearanceCreator[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAppearanceCreator[] iAppearanceCreatorArray = this.findProviders();
        int n = 0;
        while (n < iAppearanceCreatorArray.length) {
            IAppearanceCreator iAppearanceCreator = iAppearanceCreatorArray[n];
            this.registerAppearanceCreator(iAppearanceCreator);
            ++n;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public synchronized IAppearanceCreator lookupAppearanceCreator(COSName cOSName) {
        this.init();
        return this.instances.get(cOSName);
    }

    public synchronized void registerAppearanceCreator(IAppearanceCreator iAppearanceCreator) {
        this.instances.put(iAppearanceCreator.getAnnotationType(), iAppearanceCreator);
    }

    public void setLookupProviders(boolean bl) {
        this.lookupProviders = bl;
    }

    public synchronized void unregisterAppearanceCreator(IAppearanceCreator iAppearanceCreator) {
        this.instances.remove(iAppearanceCreator.getAnnotationType());
    }
}

