/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSNumber;
import java.awt.geom.AffineTransform;

public class CDSMatrix
extends CDSBase {
    public static float[] MATRIX_0 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    public static float[] MATRIX_90 = new float[]{0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f};
    public static float[] MATRIX_180 = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
    public static float[] MATRIX_270 = new float[]{0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    private float a;
    private float b;
    private float c;
    private float d;
    private float e;
    private float f;

    public static CDSMatrix createFromCOS(COSArray cOSArray) {
        if (cOSArray == null) {
            return null;
        }
        CDSMatrix cDSMatrix = (CDSMatrix)cOSArray.getAttribute(CDSMatrix.class);
        if (cDSMatrix == null) {
            cDSMatrix = new CDSMatrix(cOSArray);
            cOSArray.setAttribute(CDSMatrix.class, cDSMatrix);
        }
        return cDSMatrix;
    }

    public CDSMatrix() {
        super(COSArray.createWith(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 1.0f;
        this.e = 0.0f;
        this.f = 0.0f;
    }

    protected CDSMatrix(COSArray cOSArray) {
        super(cOSArray);
        this.a = this.getA();
        this.b = this.getB();
        this.c = this.getC();
        this.d = this.getD();
        this.e = this.getE();
        this.f = this.getF();
    }

    public CDSMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        super(COSArray.createWith(f, f2, f3, f4, f5, f6));
        this.a = f;
        this.b = f2;
        this.c = f3;
        this.d = f4;
        this.e = f5;
        this.f = f6;
    }

    public CDSMatrix(float[] fArray) {
        super(COSArray.createWith(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]));
        this.a = fArray[0];
        this.b = fArray[1];
        this.c = fArray[2];
        this.d = fArray[3];
        this.e = fArray[4];
        this.f = fArray[5];
    }

    public CDSMatrix copy() {
        CDSMatrix cDSMatrix = new CDSMatrix((COSArray)this.cosGetObject().copyShallow());
        return cDSMatrix;
    }

    public float getA() {
        return ((COSNumber)this.cosGetArray().get(0)).floatValue();
    }

    public float getB() {
        return ((COSNumber)this.cosGetArray().get(1)).floatValue();
    }

    public float getC() {
        return ((COSNumber)this.cosGetArray().get(2)).floatValue();
    }

    public float getD() {
        return ((COSNumber)this.cosGetArray().get(3)).floatValue();
    }

    public float getE() {
        return ((COSNumber)this.cosGetArray().get(4)).floatValue();
    }

    public float getF() {
        return ((COSNumber)this.cosGetArray().get(5)).floatValue();
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.a = this.getA();
        this.b = this.getB();
        this.c = this.getC();
        this.d = this.getD();
        this.e = this.getE();
        this.f = this.getF();
    }

    public void rotate(float f) {
        AffineTransform affineTransform = this.toTransform();
        affineTransform.rotate(f);
        this.setTransformation(affineTransform);
    }

    public void scale(float f, float f2) {
        this.setA(this.getA() * f);
        this.setB(this.getB() * f);
        this.setC(this.getC() * f2);
        this.setD(this.getD() * f2);
    }

    public void scale(float[] fArray) {
        this.setA(this.getA() * fArray[0]);
        this.setB(this.getB() * fArray[0]);
        this.setC(this.getC() * fArray[1]);
        this.setD(this.getD() * fArray[1]);
    }

    public void setA(float f) {
        this.cosGetArray().set(0, COSFixed.create(f));
    }

    public void setB(float f) {
        this.cosGetArray().set(1, COSFixed.create(f));
    }

    public void setC(float f) {
        this.cosGetArray().set(2, COSFixed.create(f));
    }

    public void setD(float f) {
        this.cosGetArray().set(3, COSFixed.create(f));
    }

    public void setE(float f) {
        this.cosGetArray().set(4, COSFixed.create(f));
    }

    public void setF(float f) {
        this.cosGetArray().set(5, COSFixed.create(f));
    }

    public void setTransformation(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.cosGetArray().set(0, COSFixed.create(dArray[0]));
        this.cosGetArray().set(1, COSFixed.create(dArray[1]));
        this.cosGetArray().set(2, COSFixed.create(dArray[2]));
        this.cosGetArray().set(3, COSFixed.create(dArray[3]));
        this.cosGetArray().set(4, COSFixed.create(dArray[4]));
        this.cosGetArray().set(5, COSFixed.create(dArray[5]));
    }

    public void setTransformation(float f, float f2, float f3, float f4, float f5, float f6) {
        this.cosGetArray().set(0, COSFixed.create(f));
        this.cosGetArray().set(1, COSFixed.create(f2));
        this.cosGetArray().set(2, COSFixed.create(f3));
        this.cosGetArray().set(3, COSFixed.create(f4));
        this.cosGetArray().set(4, COSFixed.create(f5));
        this.cosGetArray().set(5, COSFixed.create(f6));
    }

    public void setTransformation(float[] fArray) {
        this.cosGetArray().set(0, COSFixed.create(fArray[0]));
        this.cosGetArray().set(1, COSFixed.create(fArray[1]));
        this.cosGetArray().set(2, COSFixed.create(fArray[2]));
        this.cosGetArray().set(3, COSFixed.create(fArray[3]));
        this.cosGetArray().set(4, COSFixed.create(fArray[4]));
        this.cosGetArray().set(5, COSFixed.create(fArray[5]));
    }

    public AffineTransform toTransform() {
        return new AffineTransform(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public float[] transform(float[] fArray) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            fArray2[n2] = this.a * fArray[n2] + this.c * fArray[n3] + this.e;
            fArray2[n3] = this.b * fArray[n2] + this.d * fArray[n3] + this.f;
            n2 += 2;
            n3 += 2;
        }
        return fArray2;
    }

    public void translate(float f, float f2) {
        this.setE(this.getE() + f * this.getA() + f2 * this.getB());
        this.setF(this.getF() + f * this.getC() + f2 * this.getD());
    }

    public void translate(float[] fArray) {
        this.setE(this.getE() + fArray[0] * this.getA() + fArray[1] * this.getB());
        this.setF(this.getF() + fArray[0] * this.getC() + fArray[1] * this.getD());
    }
}

