/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSTreeEntry;
import de.intarsys.pdf.cds.CDSTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.collection.EmptyIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CDSNameTreeNode
extends CDSTreeNode {
    public static final COSName DK_Names = COSName.constant("Names");

    public static CDSNameTreeNode createFromCos(COSDictionary cOSDictionary) {
        if (cOSDictionary == null) {
            return null;
        }
        return new CDSNameTreeNode(cOSDictionary);
    }

    public static CDSTreeNode createIntermediate() {
        CDSNameTreeNode cDSNameTreeNode = new CDSNameTreeNode(COSDictionary.create());
        cDSNameTreeNode.createLimits();
        cDSNameTreeNode.createKids();
        return cDSNameTreeNode;
    }

    public static CDSNameTreeNode createLeaf() {
        CDSNameTreeNode cDSNameTreeNode = new CDSNameTreeNode(COSDictionary.create());
        cDSNameTreeNode.createLimits();
        cDSNameTreeNode.createNames();
        return cDSNameTreeNode;
    }

    public static CDSNameTreeNode createRootIntermediate() {
        CDSNameTreeNode cDSNameTreeNode = new CDSNameTreeNode(COSDictionary.create());
        cDSNameTreeNode.createKids();
        return cDSNameTreeNode;
    }

    public static CDSNameTreeNode createRootLeaf() {
        CDSNameTreeNode cDSNameTreeNode = new CDSNameTreeNode(COSDictionary.create());
        cDSNameTreeNode.createNames();
        return cDSNameTreeNode;
    }

    protected CDSNameTreeNode(COSDictionary cOSDictionary) {
        super(cOSDictionary);
    }

    public void addAll(CDSNameTreeNode cDSNameTreeNode) {
        Iterator iterator = cDSNameTreeNode.iterator();
        while (iterator.hasNext()) {
            CDSNameTreeEntry cDSNameTreeEntry = (CDSNameTreeEntry)iterator.next();
            COSString cOSString = (COSString)cDSNameTreeEntry.getName().copyOptional();
            COSObject cOSObject = cDSNameTreeEntry.getValue().copyOptional();
            this.put(cOSString, cOSObject);
        }
    }

    protected void checkLimits() {
        if (this.getLimits() == null || this.getLimits().size() != 2) {
            this.createLimits();
            this.updateLimits();
        }
    }

    public boolean contains(COSString cOSString) {
        if (!this.mayContain(cOSString)) {
            return false;
        }
        List list = this.getKids();
        if (list != null) {
            for (CDSNameTreeNode cDSNameTreeNode : list) {
                if (!cDSNameTreeNode.contains(cOSString)) continue;
                return true;
            }
            return false;
        }
        List list2 = this.getEntries();
        if (list2 != null) {
            for (CDSNameTreeEntry cDSNameTreeEntry : list2) {
                int n = cDSNameTreeEntry.getName().compareTo(cOSString);
                if (n == 0) {
                    return true;
                }
                if (n <= 0) continue;
                return false;
            }
        }
        return false;
    }

    protected void createKids() {
        COSArray cOSArray = COSArray.create();
        this.cosGetDict().put(DK_Kids, cOSArray);
    }

    protected void createLimits() {
        COSArray cOSArray = COSArray.create(2);
        cOSArray.add(COSNull.create());
        cOSArray.add(COSNull.create());
        this.cosGetDict().put(DK_Limits, cOSArray);
    }

    protected void createNames() {
        COSArray cOSArray = COSArray.create();
        this.cosGetDict().put(DK_Names, cOSArray);
    }

    public COSObject get(COSString cOSString) {
        if (!this.mayContain(cOSString)) {
            return COSNull.NULL;
        }
        List list = this.getKids();
        if (list != null) {
            for (CDSNameTreeNode cDSNameTreeNode : list) {
                COSObject cOSObject = cDSNameTreeNode.get(cOSString);
                if (cOSObject.isNull()) continue;
                return cOSObject;
            }
            return COSNull.NULL;
        }
        List list2 = this.getEntries();
        if (list2 != null) {
            for (CDSNameTreeEntry cDSNameTreeEntry : list2) {
                int n = cDSNameTreeEntry.getName().compareTo(cOSString);
                if (n == 0) {
                    return cDSNameTreeEntry.getValue();
                }
                if (n <= 0) continue;
                return COSNull.NULL;
            }
        }
        return COSNull.NULL;
    }

    public List getEntries() {
        COSArray cOSArray;
        if (this.entries == null && (cOSArray = this.cosGetDict().get(DK_Names).asArray()) != null) {
            this.entries = new ArrayList();
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSString cOSString = ((COSObject)iterator.next()).asString();
                if (!iterator.hasNext()) break;
                COSObject cOSObject = (COSObject)iterator.next();
                if (cOSString == null) continue;
                CDSNameTreeEntry cDSNameTreeEntry = new CDSNameTreeEntry(cOSString, cOSObject);
                this.entries.add(cDSNameTreeEntry);
            }
        }
        return this.entries;
    }

    public List getKids() {
        COSArray cOSArray;
        if (this.kids == null && (cOSArray = this.cosGetDict().get(DK_Kids).asArray()) != null) {
            this.kids = new ArrayList();
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSDictionary cOSDictionary = ((COSObject)iterator.next()).asDictionary();
                if (cOSDictionary == null) continue;
                CDSNameTreeNode cDSNameTreeNode = CDSNameTreeNode.createFromCos(cOSDictionary);
                this.kids.add(cDSNameTreeNode);
            }
        }
        return this.kids;
    }

    public COSArray getLimits() {
        if (this.limits == null) {
            this.limits = this.cosGetDict().get(DK_Limits).asArray();
        }
        return this.limits;
    }

    public COSString getMax() {
        if (this.getLimits() != null) {
            return this.getLimits().get(1).asString();
        }
        return null;
    }

    public COSString getMin() {
        if (this.getLimits() != null) {
            return this.getLimits().get(0).asString();
        }
        return null;
    }

    public boolean isLeaf() {
        return this.cosGetDict().containsKey(DK_Names);
    }

    public Iterator iterator() {
        List list = this.getKids();
        if (list != null) {
            return new Iterator(){
                private Iterator thisIterator;
                private Iterator childIterator;
                {
                    this.thisIterator = CDSNameTreeNode.this.getKids().iterator();
                }

                public boolean hasNext() {
                    if (this.childIterator != null && this.childIterator.hasNext()) {
                        return true;
                    }
                    if (this.thisIterator.hasNext()) {
                        CDSNameTreeNode cDSNameTreeNode = (CDSNameTreeNode)this.thisIterator.next();
                        this.childIterator = cDSNameTreeNode.iterator();
                        return this.hasNext();
                    }
                    return false;
                }

                public Object next() {
                    if (this.childIterator != null && this.childIterator.hasNext()) {
                        return this.childIterator.next();
                    }
                    if (this.thisIterator.hasNext()) {
                        CDSNameTreeNode cDSNameTreeNode = (CDSNameTreeNode)this.thisIterator.next();
                        this.childIterator = cDSNameTreeNode.iterator();
                        return this.next();
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        List list2 = this.getEntries();
        if (list2 != null) {
            return list2.iterator();
        }
        return EmptyIterator.UNIQUE;
    }

    public boolean mayContain(COSString cOSString) {
        if (this.getMin() == null || this.getMax() == null) {
            return true;
        }
        if (cOSString.compareTo(this.getMin()) < 0) {
            return false;
        }
        return cOSString.compareTo(this.getMax()) <= 0;
    }

    public COSObject put(COSString cOSString, COSObject cOSObject) {
        COSNull cOSNull = COSNull.NULL;
        List list = this.getKids();
        if (list != null) {
            CDSNameTreeNode cDSNameTreeNode = null;
            Object object = list.iterator();
            while (object.hasNext()) {
                CDSNameTreeNode cDSNameTreeNode2;
                cDSNameTreeNode = cDSNameTreeNode2 = (CDSNameTreeNode)object.next();
                if (cDSNameTreeNode2.getMax().compareTo(cOSString) > 0) break;
            }
            if (cDSNameTreeNode == null) {
                cDSNameTreeNode = CDSNameTreeNode.createLeaf();
                this.getKids().add(cDSNameTreeNode);
                object = this.cosGetDict().get(DK_Kids).asArray();
                ((COSArray)object).add(cDSNameTreeNode.cosGetObject());
            }
            cDSNameTreeNode.put(cOSString, cOSObject);
            this.updateLimits();
            return cOSNull;
        }
        List list2 = this.getEntries();
        if (list2 != null) {
            int n;
            Object object2;
            int n2 = 0;
            for (Object object2 : list2) {
                n = ((CDSNameTreeEntry)object2).getName().compareTo(cOSString);
                if (n == 0) {
                    return ((CDSTreeEntry)object2).setValue(cOSObject);
                }
                if (n > 0) break;
                ++n2;
            }
            CDSNameTreeEntry cDSNameTreeEntry = new CDSNameTreeEntry(cOSString, cOSObject);
            list2.add(n2, cDSNameTreeEntry);
            object2 = this.cosGetDict().get(DK_Names).asArray();
            n = n2 * 2;
            ((COSArray)object2).add(n, cOSObject);
            ((COSArray)object2).add(n, cOSString);
            this.updateLimits();
            return COSNull.NULL;
        }
        return cOSNull;
    }

    public COSObject remove(COSString cOSString) {
        List list = this.getKids();
        if (list != null) {
            for (CDSNameTreeNode cDSNameTreeNode : list) {
                if (cDSNameTreeNode.getMax().compareTo(cOSString) <= 0) continue;
                COSObject cOSObject = cDSNameTreeNode.remove(cOSString);
                this.updateLimits();
                return cOSObject;
            }
            return COSNull.NULL;
        }
        List list2 = this.getEntries();
        if (list2 != null) {
            int n = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                CDSNameTreeEntry cDSNameTreeEntry = (CDSNameTreeEntry)iterator.next();
                int n2 = cDSNameTreeEntry.getName().compareTo(cOSString);
                if (n2 == 0) {
                    iterator.remove();
                    COSArray cOSArray = this.cosGetDict().get(DK_Names).asArray();
                    int n3 = n * 2;
                    cOSArray.remove(n3);
                    cOSArray.remove(n3);
                    COSObject cOSObject = cDSNameTreeEntry.getValue();
                    this.updateLimits();
                    return cOSObject;
                }
                if (n2 > 0) break;
                ++n;
            }
            return COSNull.NULL;
        }
        return COSNull.NULL;
    }

    protected void updateLimits() {
        Object object;
        Object object2;
        if (this.getLimits() == null) {
            return;
        }
        List list = this.getKids();
        if (list != null && list.size() > 0) {
            object2 = (CDSNameTreeNode)list.get(0);
            ((CDSNameTreeNode)object2).checkLimits();
            this.getLimits().set(0, ((CDSNameTreeNode)object2).getLimits().get(0).copyOptional());
            object = (CDSNameTreeNode)list.get(list.size() - 1);
            ((CDSNameTreeNode)object).checkLimits();
            this.getLimits().set(1, ((CDSNameTreeNode)object).getLimits().get(1).copyOptional());
        }
        if ((object2 = this.getEntries()) != null && object2.size() > 0) {
            object = (CDSNameTreeEntry)object2.get(0);
            this.getLimits().set(0, ((CDSNameTreeEntry)object).getName().copyOptional());
            CDSNameTreeEntry cDSNameTreeEntry = (CDSNameTreeEntry)object2.get(object2.size() - 1);
            this.getLimits().set(1, cDSNameTreeEntry.getName().copyOptional());
        }
    }
}

