/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.content.CSBasicDevice;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.tools.geometry.GeometryTools;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class CSBoundingBoxCollector
extends CSBasicDevice {
    private Rectangle2D boundingBox;

    protected void addBoundingBox(Rectangle2D rectangle2D, boolean bl) {
        GeometryTools.normalizeRect((Rectangle2D)rectangle2D);
        if (bl) {
            double d = this.graphicsState.transform.getScaleX();
            d = Math.max(this.graphicsState.transform.getScaleY(), d);
            double d2 = (double)this.graphicsState.lineWidth * d + 5.0;
            rectangle2D.add(rectangle2D.getMinX() - d2, rectangle2D.getMinY() - d2);
            rectangle2D.add(rectangle2D.getMaxX() + d2, rectangle2D.getMaxY() + d2);
        }
        if (this.graphicsState.clip != null) {
            Area area = new Area(rectangle2D);
            Area area2 = new Area(this.graphicsState.clip);
            area.intersect(area2);
            if (area.isEmpty()) {
                return;
            }
            rectangle2D = area.getBounds2D();
        }
        if (this.boundingBox == null) {
            this.boundingBox = (Rectangle2D)rectangle2D.clone();
        } else {
            this.boundingBox.add(rectangle2D);
        }
    }

    protected void basicDraw(Shape shape) {
        Area area = new Area(shape.getBounds2D());
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), true);
    }

    protected void basicFill(Shape shape) {
        Area area = new Area(shape.getBounds2D());
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), true);
    }

    protected void basicTextShowGlyphs(PDGlyphs pDGlyphs, float f) throws CSException {
        double d = this.textState.fontSize / 1000.0f;
        float f2 = 0.0f;
        float f3 = (float)(pDGlyphs.getDescent() * d);
        float f4 = (float)((double)pDGlyphs.getWidth() * d);
        float f5 = (float)(pDGlyphs.getAscent() * d);
        Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
        Area area = new Area(float_);
        area.transform(this.textState.globalTransform);
        this.addBoundingBox(area.getBounds2D(), true);
        super.basicTextShowGlyphs(pDGlyphs, f);
    }

    protected void doImage(COSName cOSName, PDImage pDImage) throws CSException {
        Area area = new Area(new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f));
        area.transform(this.graphicsState.transform);
        this.addBoundingBox(area.getBounds2D(), false);
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }
}

