/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperator;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.content.CSVirtualDevice;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSConverter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class CSCreator
extends CSVirtualDevice {
    public static final float KAPPA = 0.5522848f;
    private static final float THOUSAND = 1000.0f;
    public static final int VALUE_COLOR_PRECISION = 3;
    public static final int VALUE_COORDINATE_PRECISION = 3;
    public static final int VALUE_DASH_PRECISION = 2;
    public static final int VALUE_FACTOR_PRECISION = 4;
    public static final int VALUE_FLATNESS_PRECISION = 3;
    public static final int VALUE_FONT_PRECISION = 2;
    public static final int VALUE_GRAY_PRECISION = 3;
    public static final int VALUE_WIDTH_PRECISION = 3;
    private boolean applyOperation = false;
    private final CSContent content;
    private final IContentStreamProvider contentStreamProvider;
    private PDResources resources;
    private final IResourcesProvider resourcesProvider;
    private List strings;
    private ByteArrayOutputStream textBuffer;
    private boolean textMode = false;

    public static CSCreator createFromContent(CSContent cSContent, IResourcesProvider iResourcesProvider) {
        CSCreator cSCreator = new CSCreator(cSContent, null, iResourcesProvider);
        return cSCreator;
    }

    public static CSCreator createFromProvider(IContentStreamProvider iContentStreamProvider) {
        CSCreator cSCreator = new CSCreator(iContentStreamProvider.getContentStream(), iContentStreamProvider, iContentStreamProvider);
        return cSCreator;
    }

    public static CSCreator createNew(IContentStreamProvider iContentStreamProvider) {
        CSContent cSContent = CSContent.createNew();
        CSCreator cSCreator = new CSCreator(cSContent, iContentStreamProvider, iContentStreamProvider);
        return cSCreator;
    }

    public static CSCreator createNewDetached(IResourcesProvider iResourcesProvider) {
        CSContent cSContent = CSContent.createNew();
        CSCreator cSCreator = new CSCreator(cSContent, null, iResourcesProvider);
        return cSCreator;
    }

    protected CSCreator(CSContent cSContent, IContentStreamProvider iContentStreamProvider, IResourcesProvider iResourcesProvider) {
        this.content = cSContent;
        this.contentStreamProvider = iContentStreamProvider;
        this.resourcesProvider = iResourcesProvider;
        this.open(null);
    }

    protected void basicSetNonStrokeColorSpace(PDColorSpace pDColorSpace) {
        super.basicSetNonStrokeColorSpace(pDColorSpace);
        this.applyOperation = true;
    }

    protected void basicSetNonStrokeColorValues(float[] fArray) {
        super.basicSetNonStrokeColorValues(fArray);
        this.applyOperation = true;
    }

    protected void basicSetStrokeColorSpace(PDColorSpace pDColorSpace) {
        super.basicSetStrokeColorSpace(pDColorSpace);
        this.applyOperation = true;
    }

    protected void basicSetStrokeColorValues(float[] fArray) {
        super.basicSetStrokeColorValues(fArray);
        this.applyOperation = true;
    }

    protected void basicTextShow(byte[] byArray) {
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tj);
        cSOperation.addOperand(COSString.create(byArray));
        this.getContent().addOperation(cSOperation);
    }

    protected COSName checkResource(COSName cOSName, PDObject.MetaClass metaClass, COSName cOSName2, PDObject pDObject) {
        if (this.getResources() == null) {
            throw new IllegalStateException("must have resource dictionary");
        }
        if (cOSName2 == null) {
            cOSName2 = this.getResources().createResource(cOSName, pDObject);
        } else {
            PDObject pDObject2 = this.getResources().getResource(cOSName, metaClass, cOSName2);
            if (pDObject2 == null) {
                this.getResources().addResource(cOSName, cOSName2, pDObject);
            } else if (pDObject != pDObject2) {
                cOSName2 = this.getResources().createResource(cOSName, pDObject);
            }
        }
        return cOSName2;
    }

    public void close() {
        this.flush();
        super.close();
    }

    public void compatibilityBegin() {
        super.compatibilityBegin();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_BX);
        this.getContent().addOperation(cSOperation);
    }

    public void compatibilityEnd() {
        super.compatibilityEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_EX);
        this.getContent().addOperation(cSOperation);
    }

    public void copy(CSContent cSContent) {
        int n = cSContent.size();
        int n2 = 0;
        while (n2 < n) {
            CSOperation cSOperation = cSContent.getOperation(n2);
            this.operationAdd(cSOperation);
            ++n2;
        }
    }

    public void doShading(COSName cOSName, PDShading pDShading) {
        this.textEnd();
        cOSName = this.checkResource(PDResources.CN_RT_Shading, PDShading.META, cOSName, pDShading);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_sh);
        cSOperation.addOperand(cOSName);
        this.getContent().addOperation(cSOperation);
    }

    public void doXObject(COSName cOSName, PDXObject pDXObject) {
        this.textEnd();
        cOSName = this.checkResource(PDResources.CN_RT_XObject, PDXObject.META, cOSName, pDXObject);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Do);
        cSOperation.addOperand(cOSName);
        this.getContent().addOperation(cSOperation);
    }

    public void flush() {
        this.textEnd();
        if (this.getContentStreamProvider() != null) {
            this.getContentStreamProvider().setContentStream(this.getContent());
        }
    }

    public CSContent getContent() {
        return this.content;
    }

    public IContentStreamProvider getContentStreamProvider() {
        return this.contentStreamProvider;
    }

    protected PDResources getResources() {
        if (this.resources == null) {
            this.resources = this.getResourcesProvider().getResources();
            if (this.resources == null) {
                this.resources = (PDResources)PDResources.META.createNew();
                this.getResourcesProvider().setResources(this.resources);
            }
        }
        return this.resources;
    }

    public IResourcesProvider getResourcesProvider() {
        return this.resourcesProvider;
    }

    protected List getStrings() {
        return this.strings;
    }

    protected ByteArrayOutputStream getTextBuffer() {
        return this.textBuffer;
    }

    public void inlineImage(PDImage pDImage) {
    }

    protected boolean isFont(PDFont pDFont, float f) {
        TextState textState = this.textState;
        return textState.font != null && textState.font.equals(pDFont) && textState.fontSize == f;
    }

    protected boolean isTextMode() {
        return this.textMode;
    }

    public void markedContentBegin(COSName cOSName) {
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_BMC);
        cSOperation.addOperand(cOSName.copyOptional());
        this.getContent().addOperation(cSOperation);
    }

    public void markedContentBeginProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
    }

    public void markedContentEnd() {
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_EMC);
        this.getContent().addOperation(cSOperation);
    }

    public void markedContentPoint(COSName cOSName) {
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_MP);
        cSOperation.addOperand(cOSName.copyOptional());
        this.getContent().addOperation(cSOperation);
    }

    public void markedContentPointProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
    }

    public void open(ICSInterpreter iCSInterpreter) {
        super.open(iCSInterpreter);
        this.resetStrings();
    }

    protected void operationAdd(CSOperation cSOperation) {
        this.getContent().addOperation(cSOperation);
    }

    public void pathClipEvenOdd() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Wstar);
        this.getContent().addOperation(cSOperation);
    }

    public void pathClipNonZero() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_W);
        this.getContent().addOperation(cSOperation);
    }

    public void pathClose() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_h);
        this.getContent().addOperation(cSOperation);
    }

    public void pathCloseFillStrokeEvenOdd() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_bstar);
        this.getContent().addOperation(cSOperation);
    }

    public void pathCloseFillStrokeNonZero() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_b);
        this.getContent().addOperation(cSOperation);
    }

    public void pathCloseStroke() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_s);
        this.getContent().addOperation(cSOperation);
    }

    public void pathEnd() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_n);
        this.getContent().addOperation(cSOperation);
    }

    public void pathFillEvenOdd() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_fstar);
        this.getContent().addOperation(cSOperation);
    }

    public void pathFillNonZero() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_f);
        this.getContent().addOperation(cSOperation);
    }

    public void pathFillStrokeEvenOdd() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Bstar);
        this.getContent().addOperation(cSOperation);
    }

    public void pathFillStrokeNonZero() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_B);
        this.getContent().addOperation(cSOperation);
    }

    public void pathStroke() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_S);
        this.getContent().addOperation(cSOperation);
    }

    public void penCircle(float f, float f2, float f3) {
        this.penEllipse(f, f2, f3, f3);
    }

    public void penCurveToC(float f, float f2, float f3, float f4, float f5, float f6) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_c);
        cSOperation.addOperand(COSFixed.create(f));
        cSOperation.addOperand(COSFixed.create(f2));
        cSOperation.addOperand(COSFixed.create(f3));
        cSOperation.addOperand(COSFixed.create(f4));
        cSOperation.addOperand(COSFixed.create(f5));
        cSOperation.addOperand(COSFixed.create(f6));
        this.getContent().addOperation(cSOperation);
    }

    public void penCurveToV(float f, float f2, float f3, float f4) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_v);
        cSOperation.addOperand(COSFixed.create(f));
        cSOperation.addOperand(COSFixed.create(f2));
        cSOperation.addOperand(COSFixed.create(f3));
        cSOperation.addOperand(COSFixed.create(f4));
        this.getContent().addOperation(cSOperation);
    }

    public void penCurveToY(float f, float f2, float f3, float f4) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_y);
        cSOperation.addOperand(COSFixed.create(f));
        cSOperation.addOperand(COSFixed.create(f2));
        cSOperation.addOperand(COSFixed.create(f3));
        cSOperation.addOperand(COSFixed.create(f4));
        this.getContent().addOperation(cSOperation);
    }

    public void penEllipse(float f, float f2, float f3, float f4) {
        this.textEnd();
        float f5 = f3 * 0.5522848f;
        float f6 = f4 * 0.5522848f;
        this.penMoveTo(f + f3, f2);
        this.penCurveToC(f + f3, f2 + f6, f + f5, f2 + f4, f, f2 + f4);
        this.penCurveToC(f - f5, f2 + f4, f - f3, f2 + f6, f - f3, f2);
        this.penCurveToC(f - f3, f2 - f6, f - f5, f2 - f4, f, f2 - f4);
        this.penCurveToC(f + f5, f2 - f4, f + f3, f2 - f6, f + f3, f2);
    }

    public void penLineTo(float f, float f2) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_l);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void penMoveTo(float f, float f2) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_m);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void penRectangle(float f, float f2, float f3, float f4) {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_re);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        cSOperation.addOperand(COSFixed.create(f3, 3));
        cSOperation.addOperand(COSFixed.create(f4, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void perform(byte[] byArray, COSObject ... cOSObjectArray) {
        CSOperation cSOperation = new CSOperation(byArray, cOSObjectArray);
        this.getContent().addOperation(cSOperation);
    }

    public void perform(CSOperator cSOperator, COSObject ... cOSObjectArray) {
        CSOperation cSOperation = new CSOperation(cSOperator, cOSObjectArray);
        this.getContent().addOperation(cSOperation);
    }

    public void perform(String string, COSObject ... cOSObjectArray) {
        CSOperation cSOperation = new CSOperation(StringTools.toByteArray((String)string), cOSObjectArray);
        this.getContent().addOperation(cSOperation);
    }

    protected void resetStrings() {
        this.strings = new ArrayList();
        this.resetTextBuffer();
    }

    protected void resetTextBuffer() {
        this.textBuffer = new ByteArrayOutputStream();
    }

    public void restoreState() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Q);
        this.getContent().addOperation(cSOperation);
        super.restoreState();
    }

    public void saveState() {
        this.textEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_q);
        this.getContent().addOperation(cSOperation);
        super.saveState();
    }

    public void setExtendedState(COSName cOSName, PDExtGState pDExtGState) {
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_ExtGState, PDExtGState.META, cOSName, pDExtGState);
        super.setExtendedState(cOSName, pDExtGState);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_gs);
        cSOperation.addOperand(cOSName);
        this.getContent().addOperation(cSOperation);
    }

    public void setFlatnessTolerance(float f) {
        this.streamEnd();
        super.setFlatnessTolerance(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_i);
        cSOperation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setLineCap(int n) {
        this.streamEnd();
        super.setLineCap(n);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_J);
        cSOperation.addOperand(COSInteger.create(n));
        this.getContent().addOperation(cSOperation);
    }

    public void setLineDash(float f, float f2, float f3) {
        this.setLineDash(new float[]{f, f2}, f3);
    }

    public void setLineDash(float[] fArray, float f) {
        this.streamEnd();
        super.setLineDash(fArray, f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_d);
        cSOperation.addOperand(COSConverter.toCos(fArray));
        cSOperation.addOperand(COSFixed.create(f, 2));
        this.getContent().addOperation(cSOperation);
    }

    public void setLineJoin(int n) {
        this.streamEnd();
        super.setLineJoin(n);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_j);
        cSOperation.addOperand(COSInteger.create(n));
        this.getContent().addOperation(cSOperation);
    }

    public void setLineWidth(float f) {
        if (this.graphicsState.lineWidth == f) {
            return;
        }
        this.streamEnd();
        super.setLineWidth(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_w);
        cSOperation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setMiterLimit(float f) {
        this.streamEnd();
        super.setMiterLimit(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_M);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorCMYK(float f, float f2, float f3, float f4) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        f4 = Math.max(0.0f, Math.min(1.0f, f4));
        super.setNonStrokeColorCMYK(f, f2, f3, f4);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_k);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        cSOperation.addOperand(COSFixed.create(f3, 3));
        cSOperation.addOperand(COSFixed.create(f4, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorGray(float f) {
        super.setNonStrokeColorGray(f);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_g);
        cSOperation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorRGB(float f, float f2, float f3) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        super.setNonStrokeColorRGB(f, f2, f3);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_rg);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        cSOperation.addOperand(COSFixed.create(f3, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        super.setNonStrokeColorSpace(cOSName, pDColorSpace);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_ColorSpace, PDColorSpace.META, cOSName, pDColorSpace);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_cs);
        cSOperation.addOperand(cOSName.copyOptional());
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorValues(float[] fArray) {
        super.setNonStrokeColorValues(fArray);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_sc);
        int n = 0;
        while (n < fArray.length) {
            cSOperation.addOperand(COSFixed.create(fArray[n], 3));
            ++n;
        }
        this.getContent().addOperation(cSOperation);
    }

    public void setNonStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_Pattern, PDPattern.META, cOSName, pDPattern);
        this.graphicsState.nonStrokeColorValues = fArray;
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_scn);
        int n = 0;
        while (n < fArray.length) {
            cSOperation.addOperand(COSFixed.create(fArray[n], 3));
            ++n;
        }
        if (cOSName != null) {
            cSOperation.addOperand(cOSName.copyShallow());
        }
        this.getContent().addOperation(cSOperation);
    }

    public void setRenderingIntent(COSName cOSName) {
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_ri);
        cSOperation.addOperand(cOSName.copyOptional());
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorCMYK(float f, float f2, float f3, float f4) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        f4 = Math.max(0.0f, Math.min(1.0f, f4));
        super.setStrokeColorCMYK(f, f2, f3, f4);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_K);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        cSOperation.addOperand(COSFixed.create(f3, 3));
        cSOperation.addOperand(COSFixed.create(f4, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorGray(float f) {
        super.setStrokeColorGray(f);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_G);
        cSOperation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorRGB(float f, float f2, float f3) {
        f = Math.max(0.0f, Math.min(1.0f, f));
        f2 = Math.max(0.0f, Math.min(1.0f, f2));
        f3 = Math.max(0.0f, Math.min(1.0f, f3));
        super.setStrokeColorRGB(f, f2, f3);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_RG);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        cSOperation.addOperand(COSFixed.create(f3, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        super.setStrokeColorSpace(cOSName, pDColorSpace);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_ColorSpace, PDColorSpace.META, cOSName, pDColorSpace);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_CS);
        cSOperation.addOperand(cOSName);
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorValues(float[] fArray) {
        super.setStrokeColorValues(fArray);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_SC);
        int n = 0;
        while (n < fArray.length) {
            cSOperation.addOperand(COSFixed.create(fArray[n], 3));
            ++n;
        }
        this.getContent().addOperation(cSOperation);
    }

    public void setStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_Pattern, PDPattern.META, cOSName, pDPattern);
        this.graphicsState.strokeColorValues = fArray;
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_SCN);
        int n = 0;
        while (n < fArray.length) {
            cSOperation.addOperand(COSFixed.create(fArray[n], 3));
            ++n;
        }
        if (cOSName != null) {
            cSOperation.addOperand(cOSName.copyShallow());
        }
        this.getContent().addOperation(cSOperation);
    }

    protected void setTextMode(boolean bl) {
        this.textMode = bl;
    }

    protected void streamEnd() {
        this.streamEndRun();
        int n = this.getStrings().size();
        if (n == 1) {
            Object e = this.getStrings().get(0);
            if (e instanceof byte[]) {
                byte[] byArray = (byte[])e;
                this.basicTextShow(byArray);
            }
        } else if (n > 1) {
            COSArray cOSArray = COSArray.create(n);
            for (Object e : this.getStrings()) {
                COSPrimitiveObject cOSPrimitiveObject;
                Object object;
                if (e instanceof byte[]) {
                    object = (byte[])e;
                    cOSPrimitiveObject = COSString.create((byte[])object);
                    cOSArray.add(cOSPrimitiveObject);
                    continue;
                }
                object = (Integer)e;
                cOSPrimitiveObject = COSInteger.create((Integer)object);
                cOSArray.add(cOSPrimitiveObject);
            }
            this.streamEndShow(cOSArray);
        }
        this.resetStrings();
    }

    protected void streamEndRun() {
        if (this.getTextBuffer().toByteArray().length > 0) {
            this.getStrings().add(this.getTextBuffer().toByteArray());
        }
        this.resetTextBuffer();
    }

    protected void streamEndShow(COSArray cOSArray) {
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_TJ);
        cSOperation.addOperand(cOSArray);
        this.getContent().addOperation(cSOperation);
    }

    public void textBegin() {
        if (this.isTextMode()) {
            return;
        }
        super.textBegin();
        this.setTextMode(true);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_BT);
        this.getContent().addOperation(cSOperation);
    }

    public void textEnd() {
        if (!this.isTextMode()) {
            return;
        }
        this.streamEnd();
        super.textEnd();
        this.setTextMode(false);
        CSOperation cSOperation = this.getContent().getLastOperation();
        if (cSOperation != null && cSOperation.matchesOperator(CSOperators.CSO_BT)) {
            this.getContent().removeLastOperation();
            return;
        }
        CSOperation cSOperation2 = new CSOperation(CSOperators.CSO_ET);
        this.getContent().addOperation(cSOperation2);
    }

    public void textLineMove(float f, float f2) {
        this.textBegin();
        this.streamEnd();
        super.textLineMove(f, f2);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Td);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void textLineMoveSetLeading(float f, float f2) {
        this.textBegin();
        this.streamEnd();
        super.textLineMove(f, f2);
        super.textSetLeading(f2);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_TD);
        cSOperation.addOperand(COSFixed.create(f, 3));
        cSOperation.addOperand(COSFixed.create(f2, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void textLineMoveTo(float f, float f2) {
        AffineTransform affineTransform = this.textState.lineTransform;
        this.textSetTransform((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), f, f2);
    }

    public void textLineNew() {
        this.textBegin();
        this.streamEnd();
        super.textLineNew();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tstar);
        this.getContent().addOperation(cSOperation);
    }

    public void textMove(float f, float f2) {
        int n;
        this.textBegin();
        if (f2 != 0.0f) {
            AffineTransform affineTransform = this.textState.transform;
            this.textSetTransform((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateX() + f, (float)affineTransform.getTranslateY() + f2);
            return;
        }
        if (f != 0.0f && (n = (int)(-f * 1000.0f / this.textState.fontSize)) != 0) {
            if (n < -10000) {
                AffineTransform affineTransform = this.textState.transform;
                this.textSetTransform((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateX() + f, (float)affineTransform.getTranslateY() + f2);
            } else {
                this.streamEndRun();
                this.getStrings().add(new Integer(n));
                this.textState.transform.translate(f, 0.0);
                this.textState.globalTransform.translate(f, 0.0);
            }
        }
    }

    public void textMoveTo(float f, float f2) {
        int n;
        this.textBegin();
        AffineTransform affineTransform = this.textState.transform;
        float f3 = f2 - (float)affineTransform.getTranslateY();
        if (f3 != 0.0f) {
            this.textSetTransform((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), f, f2);
            return;
        }
        float f4 = f - (float)affineTransform.getTranslateX();
        if (f4 != 0.0f && (n = (int)(-f4 * 1000.0f / this.textState.fontSize)) != 0) {
            if (n < -10000) {
                this.textSetTransform((float)affineTransform.getScaleX(), (float)affineTransform.getShearY(), (float)affineTransform.getShearX(), (float)affineTransform.getScaleY(), f, f2);
            } else {
                this.streamEndRun();
                this.getStrings().add(new Integer(n));
                this.textState.transform.translate(f4, 0.0);
                this.textState.globalTransform.translate(f4, 0.0);
            }
        }
    }

    public void textSetCharSpacing(float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetCharSpacing(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tc);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        if (this.getResources() == null) {
            throw new IllegalStateException("must have resource dictionary to set font");
        }
        this.textBegin();
        if (this.isFont(pDFont, f)) {
            return;
        }
        this.streamEnd();
        cOSName = this.checkResource(PDResources.CN_RT_Font, PDFont.META, cOSName, pDFont);
        super.textSetFont(cOSName, pDFont, f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tf);
        cSOperation.addOperand(cOSName);
        cSOperation.addOperand(COSFixed.create(f, 2));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetHorizontalScaling(float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetHorizontalScaling(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tz);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetLeading(float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetLeading(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_TL);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetRenderingMode(int n) {
        this.textBegin();
        this.streamEnd();
        super.textSetRenderingMode(n);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tr);
        cSOperation.addOperand(COSInteger.create(n));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetRise(float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetRise(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Ts);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.textBegin();
        this.streamEnd();
        super.textSetTransform(f, f2, f3, f4, f5, f6);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tm);
        cSOperation.addOperand(COSFixed.create(f, 4));
        cSOperation.addOperand(COSFixed.create(f2, 4));
        cSOperation.addOperand(COSFixed.create(f3, 4));
        cSOperation.addOperand(COSFixed.create(f4, 4));
        cSOperation.addOperand(COSFixed.create(f5, 3));
        cSOperation.addOperand(COSFixed.create(f6, 3));
        this.getContent().addOperation(cSOperation);
    }

    public void textSetWordSpacing(float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetWordSpacing(f);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tw);
        cSOperation.addOperand(COSFixed.create(f));
        this.getContent().addOperation(cSOperation);
    }

    public void textShow(byte[] byArray, int n, int n2) {
        this.textBegin();
        this.getTextBuffer().write(byArray, n, n2);
        float f = PDFontTools.getGlyphWidthEncoded(this.textState.font, byArray, n, n2);
        f = this.textState.fontSize * f / 1000.0f;
        this.textState.transform.translate(f, 0.0);
        this.textState.globalTransform.translate(f, 0.0);
    }

    public void textT3SetGlyphWidth(float f, float f2) {
        this.textBegin();
        this.streamEnd();
        super.textT3SetGlyphWidth(f, f2);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_d0);
        cSOperation.addOperand(COSFixed.create(f));
        cSOperation.addOperand(COSFixed.create(f2));
        this.getContent().addOperation(cSOperation);
    }

    public void textT3SetGlyphWidthBB(float f, float f2, float f3, float f4, float f5, float f6) {
        this.textBegin();
        this.streamEnd();
        super.textT3SetGlyphWidthBB(f, f2, f3, f4, f5, f6);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_d1);
        cSOperation.addOperand(COSFixed.create(f));
        cSOperation.addOperand(COSFixed.create(f2));
        cSOperation.addOperand(COSFixed.create(f3));
        cSOperation.addOperand(COSFixed.create(f4));
        cSOperation.addOperand(COSFixed.create(f5));
        cSOperation.addOperand(COSFixed.create(f6));
        this.getContent().addOperation(cSOperation);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.textEnd();
        super.transform(f, f2, f3, f4, f5, f6);
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_cm);
        cSOperation.addOperand(COSFixed.create(f, 4));
        cSOperation.addOperand(COSFixed.create(f2, 4));
        cSOperation.addOperand(COSFixed.create(f3, 4));
        cSOperation.addOperand(COSFixed.create(f4, 4));
        cSOperation.addOperand(COSFixed.create(f5, 3));
        cSOperation.addOperand(COSFixed.create(f6, 3));
        this.getContent().addOperation(cSOperation);
    }
}

