/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSTextDevice;
import de.intarsys.pdf.font.PDGlyphs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class CSCharacterParser
extends CSTextDevice {
    protected double lastStopX;
    protected double lastStopY;
    protected double lastStartX;
    protected double lastStartY;

    protected CSCharacterParser() {
    }

    protected void basicTextShowGlyphs(PDGlyphs pDGlyphs, float f) throws CSException {
        AffineTransform affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.lastStartX = affineTransform.getTranslateX();
        this.lastStartY = affineTransform.getTranslateY();
        double d = pDGlyphs.getAscent();
        double d2 = pDGlyphs.getDescent();
        double d3 = (double)this.textState.fontSize * d / 1000.0;
        double d4 = (double)this.textState.fontSize * d2 / 1000.0;
        double[] dArray = new double[]{0.0, d4, f, d3};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 2);
        float f2 = (float)this.lastStartX;
        float f3 = (float)(this.lastStartY + dArray[1]);
        float f4 = (float)dArray[2];
        float f5 = (float)(dArray[3] - dArray[1]);
        if (f4 < 0.0f) {
            f2 += f4;
            f4 = -f4;
        }
        if (f5 < 0.0f) {
            f3 += f5;
            f5 = -f5;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3, f4, f5);
        this.onCharacterFound(pDGlyphs, float_);
        super.basicTextShowGlyphs(pDGlyphs, f);
        affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.lastStopX = affineTransform.getTranslateX();
        this.lastStopY = affineTransform.getTranslateY();
    }

    protected void onCharacterFound(PDGlyphs pDGlyphs, Rectangle2D rectangle2D) {
    }
}

