/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.text;

import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.text.CSCharacterParser;
import de.intarsys.pdf.content.text.CSTextSearchCandidate;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSTextSearcher
extends CSCharacterParser {
    public static int FLOATING_CONTEXT_LENGTH = 28;
    private String basicSearchString;
    private ArrayList candidates = new ArrayList();
    private char[] floatingContext = new char[FLOATING_CONTEXT_LENGTH];
    private int floatingContextCurrent = 0;
    private ArrayList hits = new ArrayList();
    private boolean ignoreCase = true;
    private double maxDX = 5.0;
    private double maxDY = 5.0;
    private CSTextSearchCandidate nextCandidate;
    private ArrayList qualified = new ArrayList();
    private String searchString;

    protected String basicGetSearchString() {
        return this.basicSearchString;
    }

    protected void check(char c, Rectangle2D rectangle2D) {
        CSTextSearchCandidate cSTextSearchCandidate;
        Iterator iterator = this.qualified.iterator();
        while (iterator.hasNext()) {
            cSTextSearchCandidate = (CSTextSearchCandidate)iterator.next();
            if (cSTextSearchCandidate.acceptSuffix(c)) continue;
            this.hits.add(cSTextSearchCandidate.getHit());
            iterator.remove();
        }
        iterator = this.candidates.iterator();
        while (iterator.hasNext()) {
            cSTextSearchCandidate = (CSTextSearchCandidate)iterator.next();
            if (!cSTextSearchCandidate.accept(c, rectangle2D)) {
                iterator.remove();
                continue;
            }
            if (!cSTextSearchCandidate.isComplete()) continue;
            this.qualified.add(cSTextSearchCandidate);
            iterator.remove();
        }
        if (this.nextCandidate == null) {
            this.nextCandidate = new CSTextSearchCandidate(this);
        }
        if (this.nextCandidate.accept(c, rectangle2D)) {
            this.nextCandidate.setPrefix(this.getFloatingContextString());
            if (this.nextCandidate.isComplete()) {
                this.qualified.add(this.nextCandidate);
            } else {
                this.candidates.add(this.nextCandidate);
            }
            this.nextCandidate = null;
        }
        if (c != '\u0000') {
            this.floatingContext[this.floatingContextCurrent++] = c;
            if (this.floatingContextCurrent == this.floatingContext.length) {
                this.floatingContextCurrent = 0;
            }
        }
    }

    protected String getFloatingContextString() {
        String string = new String(this.floatingContext, this.floatingContextCurrent, this.floatingContext.length - this.floatingContextCurrent);
        String string2 = new String(this.floatingContext, 0, this.floatingContextCurrent);
        return String.valueOf(string) + string2;
    }

    public List getHits() {
        Iterator iterator = this.qualified.iterator();
        while (iterator.hasNext()) {
            CSTextSearchCandidate cSTextSearchCandidate = (CSTextSearchCandidate)iterator.next();
            cSTextSearchCandidate.flush();
            this.hits.add(cSTextSearchCandidate.getHit());
            iterator.remove();
        }
        return this.hits;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    protected void onCharacterFound(PDGlyphs pDGlyphs, Rectangle2D rectangle2D) {
        char c = (char)pDGlyphs.getUnicode();
        if (c == '\u0000') {
            c = ' ';
        }
        double d = this.lastStopX - this.lastStartX;
        double d2 = this.lastStopY - this.lastStartY;
        if (Math.abs(d) < this.maxDX) {
            if (Math.abs(d2) < this.maxDY) {
                this.check(c, rectangle2D);
            } else {
                Rectangle2D.Float float_ = new Rectangle2D.Float((int)this.lastStartX, (int)this.lastStartY, 0.0f, 0.0f);
                this.check(' ', float_);
                this.check(c, rectangle2D);
            }
        } else {
            Rectangle2D.Float float_ = new Rectangle2D.Float((int)this.lastStartX, (int)this.lastStartY, 0.0f, 0.0f);
            this.check(' ', float_);
            this.check(c, rectangle2D);
        }
    }

    public void open(ICSInterpreter iCSInterpreter) {
        super.open(iCSInterpreter);
        this.candidates.clear();
        this.hits.clear();
        this.nextCandidate = null;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
        this.basicSearchString = this.isIgnoreCase() && this.searchString != null ? this.searchString.toLowerCase() : this.searchString;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.basicSearchString = this.isIgnoreCase() ? string.toLowerCase() : string;
    }

    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        super.textSetFont(cOSName, pDFont, f);
        AffineTransform affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * affineTransform.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * affineTransform.getScaleY();
    }

    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        super.textSetTransform(f, f2, f3, f4, f5, f6);
        AffineTransform affineTransform = (AffineTransform)this.getDeviceTransform().clone();
        affineTransform.concatenate(this.textState.globalTransform);
        this.maxDX = (double)this.textState.fontSize * 0.2 * affineTransform.getScaleX();
        this.maxDY = (double)this.textState.fontSize * 0.6 * affineTransform.getScaleY();
    }
}

