/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.filter.FilterFactory;
import de.intarsys.pdf.filter.IFilter;
import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class COSStream
extends COSCompositeObject {
    public static final COSName DK_DecodeParms = COSName.constant("DecodeParms");
    public static final COSName DK_DP = COSName.constant("DP");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_FDecodeParams = COSName.constant("FDecodeParams");
    public static final COSName DK_FFilter = COSName.constant("FFilter");
    public static final COSName DK_Filter = COSName.constant("Filter");
    public static final COSName DK_Length = COSName.constant("Length");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final Object SLOT_BYTES = new Object();
    private byte[] decodedBytes;
    private COSDictionary dict;
    private byte[] encodedBytes;

    public static COSStream create(COSDictionary cOSDictionary) {
        COSStream cOSStream = new COSStream(cOSDictionary);
        cOSStream.beIndirect();
        return cOSStream;
    }

    public static COSObject getDecodeParams(COSDictionary cOSDictionary) {
        if (COSStream.isExternal(cOSDictionary)) {
            return cOSDictionary.get(DK_FDecodeParams);
        }
        COSObject cOSObject = cOSDictionary.get(DK_DP);
        if (!cOSObject.isNull()) {
            return cOSObject;
        }
        return cOSDictionary.get(DK_DecodeParms);
    }

    public static COSDictionary getDecodeParams(COSDictionary cOSDictionary, COSName cOSName) {
        COSObject cOSObject = COSStream.getFilters(cOSDictionary);
        if (cOSObject instanceof COSName) {
            COSName cOSName2 = cOSObject.asName();
            if (cOSName2.equals(cOSName)) {
                return cOSDictionary.get(DK_DecodeParms).asDictionary();
            }
        } else if (cOSObject instanceof COSArray) {
            COSArray cOSArray = cOSObject.asArray();
            int n = 0;
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSArray cOSArray2;
                COSName cOSName3 = ((COSObject)iterator.next()).asName();
                if (cOSName3 != null && cOSName3.equals(cOSName) && (cOSArray2 = cOSDictionary.get(DK_DecodeParms).asArray()) != null) {
                    return cOSArray2.get(n).asDictionary();
                }
                ++n;
            }
        }
        return null;
    }

    public static COSObject getFilters(COSDictionary cOSDictionary) {
        if (COSStream.isExternal(cOSDictionary)) {
            return cOSDictionary.get(DK_FFilter);
        }
        COSObject cOSObject = cOSDictionary.get(DK_F);
        if (!cOSObject.isNull()) {
            return cOSObject;
        }
        return cOSDictionary.get(DK_Filter);
    }

    public static boolean hasFilter(COSDictionary cOSDictionary, COSName cOSName) {
        COSObject cOSObject = COSStream.getFilters(cOSDictionary);
        if (cOSObject.isNull()) {
            return false;
        }
        if (cOSObject instanceof COSName) {
            return cOSObject.equals(cOSName);
        }
        if (cOSObject instanceof COSArray) {
            Iterator iterator = ((COSArray)cOSObject).iterator();
            while (iterator.hasNext()) {
                COSName cOSName2 = ((COSObject)iterator.next()).asName();
                if (cOSName2 == null || !cOSName2.equals(cOSName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExternal(COSDictionary cOSDictionary) {
        COSObject cOSObject = cOSDictionary.get(DK_F);
        if (!cOSObject.isNull()) {
            return !(cOSObject instanceof COSName) && !(cOSObject instanceof COSArray);
        }
        return false;
    }

    protected COSStream() {
    }

    protected COSStream(COSDictionary cOSDictionary) {
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
        }
        this.setDict(cOSDictionary);
    }

    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromStream(this);
    }

    public void addFilter(COSName cOSName) {
        this.addFilter(this.getFilterSize(), cOSName, null);
    }

    public void addFilter(COSName cOSName, COSDictionary cOSDictionary) {
        this.addFilter(this.getFilterSize(), cOSName, cOSDictionary);
    }

    public void addFilter(int n, COSName cOSName) {
        this.addFilter(n, cOSName, null);
    }

    public void addFilter(int n, COSName cOSName, COSDictionary cOSDictionary) {
        this.getDecodedBytes();
        this.encodedBytes = null;
        COSObject cOSObject = this.getFilters();
        if (cOSObject.isNull()) {
            this.getDict().put(DK_Filter, cOSName);
            this.getDict().put(DK_DecodeParms, cOSDictionary);
        } else {
            COSArray cOSArray;
            COSName cOSName2 = cOSObject.asName();
            if (cOSName2 != null) {
                this.getDict().remove(DK_Filter);
                cOSArray = COSArray.create(2);
                cOSArray.add(cOSName2);
            } else {
                cOSArray = cOSObject.asArray();
            }
            cOSArray.add(n, cOSName);
            this.getDict().put(DK_Filter, cOSArray);
            COSObject cOSObject2 = this.getDecodeParams();
            COSArray cOSArray2 = null;
            if (cOSObject2.isNull() && cOSDictionary != null) {
                cOSArray2 = COSArray.create(cOSArray.size());
                int n2 = 0;
                while (n2 < cOSArray.size() - 1) {
                    cOSArray2.add(COSNull.NULL);
                    ++n2;
                }
            } else {
                COSDictionary cOSDictionary2 = cOSObject2.asDictionary();
                if (cOSDictionary2 != null) {
                    this.getDict().remove(DK_DecodeParms);
                    cOSArray2 = COSArray.create(cOSArray.size());
                    cOSArray2.add(cOSDictionary2);
                } else {
                    cOSArray2 = cOSObject2.asArray();
                }
            }
            if (cOSArray2 != null) {
                if (cOSDictionary == null) {
                    cOSArray2.add(n, COSNull.NULL);
                } else {
                    cOSArray2.add(n, cOSDictionary);
                }
            }
            this.getDict().put(DK_DecodeParms, cOSArray2);
        }
    }

    public void addObjectListener(ICOSObjectListener iCOSObjectListener) {
        super.addObjectListener(iCOSObjectListener);
        if (this.dict != null) {
            this.dict.addObjectListener(iCOSObjectListener);
        }
    }

    public COSStream asStream() {
        return this;
    }

    public Iterator basicIterator() {
        return new SingleObjectIterator((Object)this.getDict());
    }

    public void basicSetDecodedBytes(byte[] byArray) {
        this.decodedBytes = byArray;
        this.encodedBytes = null;
        this.getDict().basicRemoveSilent(DK_Length);
    }

    public void basicSetEncodedBytes(byte[] byArray) {
        this.encodedBytes = byArray;
        this.decodedBytes = null;
        int n = this.encodedBytes == null ? 0 : this.encodedBytes.length;
        this.getDict().basicPutSilent(DK_Length, COSInteger.create(n));
    }

    protected String basicToString() {
        byte[] byArray = this.getDecodedBytes();
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    protected COSObject copyBasic() {
        COSStream cOSStream = new COSStream();
        cOSStream.encodedBytes = this.encodedBytes;
        cOSStream.decodedBytes = this.decodedBytes;
        return cOSStream;
    }

    public COSStream copyDecodeFirst() throws IOException {
        COSArray cOSArray;
        COSStream cOSStream = (COSStream)this.copyShallow();
        if (this.getFilters().isNull()) {
            return cOSStream;
        }
        cOSStream.basicSetDecodedBytes(null);
        cOSStream.getDict().remove(DK_DecodeParms);
        cOSStream.getDict().remove(DK_Filter);
        cOSStream.getDict().remove(DK_Length);
        byte[] byArray = this.getEncodedBytes();
        COSName cOSName = this.getFirstFilter();
        if (cOSName != null) {
            byArray = this.doDecode(cOSName, this.getFirstDecodeParam(), byArray, 0, this.getAnyLength());
        }
        if ((cOSArray = this.getFilters().asArray()) != null) {
            COSArray cOSArray2 = this.getDecodeParams().asArray();
            int n = cOSArray.size() - 1;
            while (n > 0) {
                if (cOSArray2 != null) {
                    COSDictionary cOSDictionary = cOSArray2.get(n).asDictionary();
                    if (cOSDictionary != null) {
                        cOSDictionary = (COSDictionary)cOSDictionary.copyShallow();
                    }
                    cOSStream.filter((COSName)cOSArray.get(n).copyShallow(), cOSDictionary);
                } else {
                    cOSStream.filter((COSName)cOSArray.get(n).copyShallow());
                }
                --n;
            }
        }
        cOSStream.setEncodedBytes(byArray);
        return cOSStream;
    }

    public COSObject copyDeep(Map map) {
        COSStream cOSStream = (COSStream)super.copyDeep(map);
        cOSStream.setDict((COSDictionary)this.getDict().copyDeep(map));
        if (this.encodedBytes != null) {
            cOSStream.setEncodedBytes(this.encodedBytes);
        } else {
            cOSStream.setDecodedBytes(this.decodedBytes);
        }
        return cOSStream;
    }

    public COSObject copyShallow() {
        COSStream cOSStream = (COSStream)super.copyShallow();
        cOSStream.setDict((COSDictionary)this.getDict().copyShallow());
        if (this.encodedBytes != null) {
            cOSStream.setEncodedBytes(this.encodedBytes);
        } else {
            cOSStream.setDecodedBytes(this.decodedBytes);
        }
        return cOSStream;
    }

    protected COSObject copySubGraph(Map map) {
        COSStream cOSStream = (COSStream)super.copySubGraph(map);
        cOSStream.setDict((COSDictionary)this.getDict().copySubGraph(map));
        if (this.encodedBytes != null) {
            cOSStream.setEncodedBytes(this.encodedBytes);
        } else {
            cOSStream.setDecodedBytes(this.decodedBytes);
        }
        return cOSStream;
    }

    protected byte[] doDecode() throws IOException {
        byte[] byArray;
        if (this.isExternal() && this.isBytesArrayEmpty(this.encodedBytes)) {
            this.encodedBytes = null;
            this.parseFKeyedFile();
        }
        if (this.encodedBytes == null) {
            return null;
        }
        COSObject cOSObject = this.getFilters();
        if (cOSObject.isNull()) {
            byte[] byArray2;
            int n = this.getLength();
            if (n != -1 && this.encodedBytes.length > n) {
                byArray2 = new byte[n];
                System.arraycopy(this.encodedBytes, 0, byArray2, 0, n);
            } else {
                byArray2 = this.encodedBytes;
            }
            return byArray2;
        }
        COSObject cOSObject2 = this.getDecodeParams();
        if (cOSObject instanceof COSName) {
            byArray = this.doDecode((COSName)cOSObject, cOSObject2.asDictionary(), this.encodedBytes, 0, this.getAnyLength());
        } else {
            byte[] byArray3 = this.encodedBytes;
            int n = this.getAnyLength();
            int n2 = 0;
            while (n2 < ((COSArray)cOSObject).size()) {
                COSName cOSName;
                COSObject cOSObject3 = COSNull.NULL;
                if (!cOSObject2.isNull()) {
                    cOSObject3 = ((COSArray)cOSObject2).get(n2);
                }
                if ((byArray3 = this.doDecode(cOSName = ((COSArray)cOSObject).get(n2).asName(), cOSObject3.asDictionary(), byArray3, 0, n)) != null) {
                    n = byArray3.length;
                }
                ++n2;
            }
            byArray = byArray3;
        }
        return byArray;
    }

    protected byte[] doDecode(COSName cOSName, COSDictionary cOSDictionary, byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return new byte[0];
        }
        IFilter iFilter = FilterFactory.get().createFilter(cOSName, cOSDictionary);
        iFilter.setStream(this);
        return iFilter.decode(byArray, n, n2);
    }

    protected void doEncode() throws IOException {
        if (this.decodedBytes == null) {
            return;
        }
        COSObject cOSObject = this.getFilters();
        if (cOSObject.isNull()) {
            this.encodedBytes = this.decodedBytes;
            return;
        }
        COSObject cOSObject2 = this.getDecodeParams();
        if (cOSObject instanceof COSName) {
            this.encodedBytes = this.doEncode((COSName)cOSObject, cOSObject2.asDictionary(), this.decodedBytes, 0, this.decodedBytes.length);
        } else {
            byte[] byArray = this.decodedBytes;
            int n = this.decodedBytes.length;
            int n2 = ((COSArray)cOSObject).size() - 1;
            while (n2 >= 0) {
                COSDictionary cOSDictionary = null;
                if (!cOSObject2.isNull()) {
                    cOSDictionary = ((COSArray)cOSObject2).get(n2).asDictionary();
                }
                COSName cOSName = ((COSArray)cOSObject).get(n2).asName();
                byArray = this.doEncode(cOSName, cOSDictionary, byArray, 0, n);
                n = byArray.length;
                --n2;
            }
            this.encodedBytes = byArray;
        }
    }

    protected byte[] doEncode(COSName cOSName, COSDictionary cOSDictionary, byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return new byte[0];
        }
        IFilter iFilter = FilterFactory.get().createFilter(cOSName, cOSDictionary);
        iFilter.setStream(this);
        return iFilter.encode(byArray, n, n2);
    }

    public boolean equals(Object object) {
        return this.equals(object, new HashSet());
    }

    protected boolean equals(Object object, Set set) {
        if (this.isIndirect()) {
            if (set.contains(this.getIndirectObject())) {
                return true;
            }
            set.add(this.getIndirectObject());
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof COSStream)) {
            return false;
        }
        COSStream cOSStream = (COSStream)object;
        if (!this.getDict().equals(cOSStream.getDict())) {
            return false;
        }
        if (this.getLength() != cOSStream.getLength()) {
            return false;
        }
        return Arrays.equals(this.getEncodedBytes(), cOSStream.getEncodedBytes());
    }

    public void filter(COSName cOSName) {
        this.addFilter(0, cOSName, null);
    }

    public void filter(COSName cOSName, COSDictionary cOSDictionary) {
        this.addFilter(0, cOSName, cOSDictionary);
    }

    public int getAnyLength() {
        int n = this.getLength();
        if (n == -1) {
            return this.encodedBytes.length;
        }
        return n;
    }

    public byte[] getDecodedBytes() {
        if (this.decodedBytes == null) {
            try {
                this.decodedBytes = this.doDecode();
            }
            catch (IOException iOException) {
                this.handleException(new COSRuntimeException("error decoding stream", iOException));
            }
        }
        return this.decodedBytes;
    }

    public byte[] getDecodedBytesWritable() {
        byte[] byArray;
        try {
            byArray = this.doDecode();
            if (byArray != this.encodedBytes) {
                return byArray;
            }
        }
        catch (IOException iOException) {
            this.handleException(new COSRuntimeException("error decoding stream", iOException));
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public COSObject getDecodeParams() {
        return COSStream.getDecodeParams(this.getDict());
    }

    public COSDictionary getDecodeParams(COSName cOSName) {
        return COSStream.getDecodeParams(this.getDict(), cOSName);
    }

    public COSDictionary getDict() {
        return this.dict;
    }

    public byte[] getEncodedBytes() {
        if (this.encodedBytes == null) {
            try {
                this.doEncode();
            }
            catch (IOException iOException) {
                this.handleException(new COSRuntimeException("error encoding stream", iOException));
            }
            int n = this.encodedBytes == null ? 0 : this.encodedBytes.length;
            this.getDict().basicPutSilent(DK_Length, COSInteger.create(n));
        }
        return this.encodedBytes;
    }

    public COSObject getFilters() {
        return COSStream.getFilters(this.getDict());
    }

    public int getFilterSize() {
        COSObject cOSObject = this.getFilters();
        if (cOSObject.isNull()) {
            return 0;
        }
        if (cOSObject.asName() != null) {
            return 1;
        }
        return cOSObject.asArray().size();
    }

    public COSDictionary getFirstDecodeParam() {
        COSObject cOSObject = this.getDecodeParams();
        if (cOSObject.isNull()) {
            return null;
        }
        if (cOSObject instanceof COSDictionary) {
            return (COSDictionary)cOSObject;
        }
        if (cOSObject instanceof COSArray) {
            return ((COSArray)cOSObject).get(0).asDictionary();
        }
        return null;
    }

    public COSName getFirstFilter() {
        COSObject cOSObject = this.getFilters();
        if (cOSObject.isNull()) {
            return null;
        }
        if (cOSObject instanceof COSName) {
            return (COSName)cOSObject;
        }
        if (cOSObject instanceof COSArray) {
            return ((COSArray)cOSObject).get(0).asName();
        }
        return null;
    }

    public int getLength() {
        COSInteger cOSInteger = this.dict.get(DK_Length).asInteger();
        if (cOSInteger != null) {
            return ((COSNumber)cOSInteger).intValue();
        }
        return -1;
    }

    public boolean hasFilter(COSName cOSName) {
        return COSStream.hasFilter(this.getDict(), cOSName);
    }

    private boolean isBytesArrayEmpty(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return true;
        }
        return byArray.length == 2 && byArray[0] == 13 && byArray[1] == 10;
    }

    public boolean isExternal() {
        return COSStream.isExternal(this.getDict());
    }

    public Iterator iterator() {
        return new SingleObjectIterator((Object)this.getDict());
    }

    protected void parseFKeyedFile() {
        byte[] byArray;
        COSObject cOSObject = this.dict.get(DK_F);
        String string = "";
        if (!(cOSObject instanceof COSString)) {
            return;
        }
        string = ((COSString)cOSObject).stringValue();
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            byArray = FileTools.toBytes((File)file);
        }
        catch (IOException iOException) {
            return;
        }
        if (byArray != null) {
            this.encodedBytes = byArray;
        }
    }

    public void removeFilters() {
        this.getDecodedBytes();
        this.encodedBytes = null;
        this.getDict().remove(DK_Filter);
    }

    public void removeObjectListener(ICOSObjectListener iCOSObjectListener) {
        super.removeObjectListener(iCOSObjectListener);
        if (this.dict != null) {
            this.dict.removeObjectListener(iCOSObjectListener);
        }
    }

    public void restoreState(Object object) {
        super.restoreState(object);
        COSStream cOSStream = (COSStream)object;
        this.encodedBytes = cOSStream.encodedBytes;
        this.decodedBytes = cOSStream.decodedBytes;
        this.triggerChanged(null, null, null);
    }

    public Object saveState() {
        COSStream cOSStream = new COSStream();
        cOSStream.encodedBytes = this.encodedBytes;
        cOSStream.decodedBytes = this.decodedBytes;
        cOSStream.container = this.container.saveStateContainer();
        return cOSStream;
    }

    public void setDecodedBytes(byte[] byArray) {
        this.willChange(this);
        this.basicSetDecodedBytes(byArray);
        if (this.objectListeners != null) {
            this.triggerChanged(SLOT_BYTES, null, null);
        }
    }

    private void setDict(COSDictionary cOSDictionary) {
        if (cOSDictionary.isIndirect()) {
            throw new IllegalArgumentException("stream dictionary cannot be indirect");
        }
        this.dict = cOSDictionary;
        this.dict.addContainer(this);
    }

    public void setEncodedBytes(byte[] byArray) {
        this.willChange(this);
        this.basicSetEncodedBytes(byArray);
        if (this.objectListeners != null) {
            this.triggerChanged(SLOT_BYTES, null, null);
        }
    }
}

